/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.rest.framework.resource.SerializablePagedCollection;
import org.alfresco.rest.framework.resource.parameters.ArrayListPage;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrayListPageTest
extends TestCase {
    private List<PageFormat> getPageFormats() {
        return List.of(new PageFormat(10, 0), new PageFormat(10, 10), new PageFormat(110, 20));
    }

    @Test
    public void testCreatePage() {
        List<PageFormat> pageFormats = this.getPageFormats();
        for (PageFormat pageFormat : pageFormats) {
            int pageSize = pageFormat.size;
            int offset = pageFormat.offset;
            List<Object> list = ArrayListPageTest.randomListOf(offset, 100, Object.class);
            Paging paging = Paging.valueOf((int)offset, (int)pageSize);
            ArrayListPage page = new ArrayListPage(list, paging);
            ((AbstractObjectAssert)((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)page).isNotNull()).extracting(SerializablePagedCollection::getCollection).isNotNull()).isEqualTo(list.subList(offset, Math.min(offset + pageSize, list.size())))).extracting(Collection::size).isEqualTo((Object)Math.min(pageSize, list.size() - offset));
            Assertions.assertThat((Integer)page.getTotalItems()).isEqualTo(list.size());
            Assertions.assertThat((boolean)page.hasMoreItems()).isEqualTo(list.size() - offset > pageSize);
            Assertions.assertThat((Object)page.getPaging()).isNotNull();
        }
    }

    @Test
    public void testCreatePageWithoutPaging() {
        List<Object> list = ArrayListPageTest.randomListOf(0, 100, Object.class);
        ArrayListPage page = new ArrayListPage(list);
        ((AbstractObjectAssert)((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)page).isNotNull()).extracting(SerializablePagedCollection::getCollection).isNotNull()).isEqualTo(list)).extracting(Collection::size).isEqualTo((Object)list.size());
        Assertions.assertThat((Integer)page.getTotalItems()).isEqualTo(list.size());
        Assertions.assertThat((boolean)page.hasMoreItems()).isFalse();
        Assertions.assertThat((Object)page.getPaging()).isNull();
    }

    @Test
    public void testCreatePageForBiggerOffsetThanListSize() {
        int offset = 10;
        List<Object> list = ArrayListPageTest.createListOf(8, Object.class);
        Paging paging = Paging.valueOf((int)10, (int)5);
        ArrayListPage page = new ArrayListPage(list, paging);
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)page).isNotNull()).extracting(SerializablePagedCollection::getCollection).isNotNull()).extracting(Collection::isEmpty).isEqualTo((Object)true);
        Assertions.assertThat((Integer)page.getTotalItems()).isEqualTo(list.size());
        Assertions.assertThat((boolean)page.hasMoreItems()).isFalse();
    }

    @Test
    public void testCreatePageForNullList() {
        ArrayListPage page = new ArrayListPage(null, Paging.DEFAULT);
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)page).isNotNull()).extracting(SerializablePagedCollection::getCollection).isNotNull()).extracting(Collection::isEmpty).isEqualTo((Object)true);
        Assertions.assertThat((Integer)page.getTotalItems()).isEqualTo(0);
        Assertions.assertThat((boolean)page.hasMoreItems()).isFalse();
    }

    @Test
    public void testCreatePageForNullPaging() {
        List<Object> list = ArrayListPageTest.createListOf(18, Object.class);
        ArrayListPage page = new ArrayListPage(list, null);
        ((AbstractObjectAssert)((ObjectAssert)Assertions.assertThat((Object)page).isNotNull()).extracting(SerializablePagedCollection::getCollection).isNotNull()).extracting(Collection::size).isEqualTo((Object)list.size());
        Assertions.assertThat((Integer)page.getTotalItems()).isEqualTo(list.size());
        Assertions.assertThat((boolean)page.hasMoreItems()).isFalse();
        Assertions.assertThat((Object)page.getPaging()).isNull();
    }

    private static <T> List<T> randomListOf(int minSize, int maxSize, Class<T> clazz) {
        return ArrayListPageTest.createListOf(new Random().nextInt(maxSize - minSize + 1) + minSize, clazz);
    }

    private static <T> List<T> createListOf(int size2, Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size2; ++i) {
            list.add(Mockito.mock(clazz));
        }
        Collections.shuffle(list);
        return list;
    }

    private static final class PageFormat {
        private final int size;
        private final int offset;

        public PageFormat(int size2, int offset) {
            this.size = size2;
            this.offset = offset;
        }
    }
}

