/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.people;

import org.alfresco.rest.api.Preferences;
import org.alfresco.rest.api.model.Preference;
import org.alfresco.rest.api.people.PeopleEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="preferences", entityResource=PeopleEntityResource.class, title="Person Preferences")
public class PersonPreferencesRelation
implements RelationshipResourceAction.Read<Preference>,
RelationshipResourceAction.ReadById<Preference>,
RelationshipResourceAction.Update<Preference>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(PersonPreferencesRelation.class);
    private Preferences preferences;

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"preferences", (Object)this.preferences);
    }

    @Override
    @WebApiDescription(title="A paged list of the persons preferences.")
    public CollectionWithPagingInfo<Preference> readAll(String personId, Parameters parameters) {
        return this.preferences.getPreferences(personId, parameters.getPaging());
    }

    @Override
    @WebApiDescription(title="Preference value for preference 'preferenceName' for person 'personId'.")
    public Preference readById(String personId, String preferenceName, Parameters parameters) {
        String url = parameters.getRequest().getURL();
        if (url.matches(".*workspace://SpacesStore/.*")) {
            preferenceName = (String)preferenceName + url.substring(url.indexOf("//SpacesStore/"));
        }
        return this.preferences.getPreference(personId, (String)preferenceName);
    }

    @Override
    public Preference update(String personId, Preference preference, Parameters parameters) {
        if (preference.getName() == null || preference.getName().isBlank()) {
            throw new InvalidArgumentException();
        }
        return this.preferences.updatePreference(personId, preference);
    }
}

