/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.model.rules.InclusionType;
import org.alfresco.rest.api.model.rules.RuleSet;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;

@Experimental
public class RuleSetLoader {
    protected static final String OWNING_FOLDER = "owningFolder";
    protected static final String INCLUSION_TYPE = "inclusionType";
    protected static final String INHERITED_BY = "inheritedBy";
    protected static final String LINKED_TO_BY = "linkedToBy";
    protected static final String IS_INHERITED = "isInherited";
    protected static final String IS_LINKED_TO = "isLinkedTo";
    protected static final String RULE_IDS = "ruleIds";
    private static final int MAX_INHERITED_BY_SIZE = 100;
    private static final int MAX_LINKED_TO_BY_SIZE = 100;
    private NodeService nodeService;
    private RuleService ruleService;

    public RuleSet loadRuleSet(NodeRef ruleSetNodeRef, NodeRef folderNodeRef, List<String> includes) {
        String ruleSetId = ruleSetNodeRef.getId();
        RuleSet ruleSet = RuleSet.of(ruleSetId);
        if (includes != null) {
            NodeRef parentRef = this.nodeService.getPrimaryParent(ruleSetNodeRef).getParentRef();
            if (includes.contains(OWNING_FOLDER)) {
                ruleSet.setOwningFolder(parentRef);
            }
            if (includes.contains(INCLUSION_TYPE)) {
                if (parentRef.equals((Object)folderNodeRef)) {
                    ruleSet.setInclusionType(InclusionType.OWNED);
                } else {
                    boolean linked = this.nodeService.getParentAssocs(ruleSetNodeRef).stream().map(ChildAssociationRef::getParentRef).anyMatch(arg_0 -> ((NodeRef)folderNodeRef).equals(arg_0));
                    ruleSet.setInclusionType(linked ? InclusionType.LINKED : InclusionType.INHERITED);
                }
            }
            if (includes.contains(INHERITED_BY)) {
                ruleSet.setInheritedBy(this.loadInheritedBy(ruleSetNodeRef));
            }
            if (includes.contains(LINKED_TO_BY)) {
                ruleSet.setLinkedToBy(this.loadLinkedToBy(ruleSetNodeRef));
            }
            if (includes.contains(IS_INHERITED)) {
                ruleSet.setIsInherited(this.loadIsInherited(ruleSetNodeRef));
            }
            if (includes.contains(IS_LINKED_TO)) {
                ruleSet.setIsLinkedTo(this.loadIsLinkedTo(ruleSetNodeRef, parentRef));
            }
            if (includes.contains(RULE_IDS)) {
                ruleSet.setRuleIds(this.loadRuleIds(parentRef));
            }
        }
        return ruleSet;
    }

    private List<NodeRef> loadInheritedBy(NodeRef ruleSetNodeRef) {
        return this.ruleService.getFoldersInheritingRuleSet(ruleSetNodeRef, 100);
    }

    private List<NodeRef> loadLinkedToBy(NodeRef ruleSetNodeRef) {
        return this.ruleService.getFoldersLinkingToRuleSet(ruleSetNodeRef, 100);
    }

    private boolean loadIsInherited(NodeRef ruleSetNodeRef) {
        return (Boolean)AuthenticationUtil.runAsSystem(() -> !this.ruleService.getFoldersInheritingRuleSet(ruleSetNodeRef, 1).isEmpty());
    }

    private Boolean loadIsLinkedTo(NodeRef ruleSetNodeRef, NodeRef parentRef) {
        return (Boolean)AuthenticationUtil.runAsSystem(() -> this.nodeService.getParentAssocs(ruleSetNodeRef).stream().map(ChildAssociationRef::getParentRef).anyMatch(folder -> !folder.equals((Object)parentRef)));
    }

    public List<String> loadRuleIds(NodeRef folderNodeRef) {
        return this.ruleService.getRules(folderNodeRef, false).stream().map(Rule::getNodeRef).map(NodeRef::getId).collect(Collectors.toList());
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }
}

