/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.alfresco.opencmis.dictionary.QNameFilter;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class ExcludedTypes {
    private List<QName> expectedTypes;
    private QNameFilter excludedTypes;
    private NodeService nodeService;

    public void setExpectedTypes(List<String> expectedTypes) {
        if (expectedTypes != null && expectedTypes.size() > 0) {
            this.expectedTypes = new ArrayList<QName>(expectedTypes.size());
            for (String type : expectedTypes) {
                QName typeDef = QName.createQName((String)type);
                this.expectedTypes.add(typeDef);
            }
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setExcludedTypes(QNameFilter excludedTypes) {
        this.excludedTypes = excludedTypes;
    }

    public boolean isExcluded(final NodeRef nodeRef) {
        boolean excluded = false;
        QName nodeType = this.nodeService.getType(nodeRef);
        if (this.expectedTypes != null && !this.expectedTypes.contains(nodeType)) {
            excluded = true;
        }
        if (!excluded) {
            excluded = (Boolean)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    boolean excluded = false;
                    HashSet aspects = new HashSet(ExcludedTypes.this.nodeService.getAspects(nodeRef));
                    for (QName aspect : aspects) {
                        if (!ExcludedTypes.this.excludedTypes.isExcluded(aspect)) continue;
                        excluded = true;
                        break;
                    }
                    return excluded;
                }
            }, (String)TenantUtil.getCurrentDomain());
        }
        return excluded;
    }
}

