/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;

public abstract class FacetablePropertyFTL<T>
implements Comparable<T> {
    protected final String localisedTitle;

    public FacetablePropertyFTL(String localisedTitle) {
        this.localisedTitle = localisedTitle;
    }

    public abstract String getShortQname();

    public abstract QName getQname();

    public abstract String getDisplayName();

    public abstract QName getContainerClassType();

    public abstract QName getDataType();

    public abstract QName getModelQname();

    public String getTitle() {
        return this.localisedTitle;
    }

    public static class FacetablePropertyFTLComparator
    implements Comparator<FacetablePropertyFTL<?>> {
        private final List<Class<?>> typeOrder = Arrays.asList(SpecialFacetablePropertyFTL.class, SyntheticFacetablePropertyFTL.class, StandardFacetablePropertyFTL.class);

        @Override
        public int compare(FacetablePropertyFTL left, FacetablePropertyFTL right) {
            if (!left.getClass().equals(right.getClass())) {
                return this.typeOrder.indexOf(left.getClass()) - this.typeOrder.indexOf(right.getClass());
            }
            return left.compareTo(right);
        }
    }

    public static class SpecialFacetablePropertyFTL
    extends FacetablePropertyFTL<SpecialFacetablePropertyFTL> {
        private final String name;
        private final String displayName;

        public SpecialFacetablePropertyFTL(String name, String localisedTitle) {
            super(localisedTitle);
            this.name = name;
            this.displayName = localisedTitle;
        }

        @Override
        public String getShortQname() {
            return this.name;
        }

        @Override
        public QName getQname() {
            return null;
        }

        @Override
        public QName getDataType() {
            return null;
        }

        @Override
        public QName getContainerClassType() {
            return null;
        }

        @Override
        public QName getModelQname() {
            return null;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public int compareTo(SpecialFacetablePropertyFTL that) {
            return this.name.compareTo(that.name);
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpecialFacetablePropertyFTL other = (SpecialFacetablePropertyFTL)obj;
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static class SyntheticFacetablePropertyFTL
    extends FacetablePropertyFTL<SyntheticFacetablePropertyFTL> {
        private final PropertyDefinition containingPropDef;
        private final String syntheticPropertyName;
        private final QName datatype;
        private final String displayName;

        public SyntheticFacetablePropertyFTL(PropertyDefinition containingPropDef, String localisedTitle, String syntheticPropertyName, QName datatype) {
            super(localisedTitle);
            this.containingPropDef = containingPropDef;
            this.syntheticPropertyName = syntheticPropertyName;
            this.datatype = datatype;
            this.displayName = this.getShortQname() + (String)(localisedTitle == null ? "" : " (" + localisedTitle + ")");
        }

        @Override
        public String getShortQname() {
            return this.containingPropDef.getName().getPrefixString() + "." + this.syntheticPropertyName;
        }

        @Override
        public QName getQname() {
            QName containingPropQName = this.containingPropDef.getName();
            return QName.createQName((String)containingPropQName.getNamespaceURI(), (String)(containingPropQName.getLocalName() + "." + this.syntheticPropertyName));
        }

        @Override
        public QName getDataType() {
            return this.datatype;
        }

        @Override
        public QName getContainerClassType() {
            return this.containingPropDef.getContainerClass().getName();
        }

        @Override
        public QName getModelQname() {
            return this.containingPropDef.getModel().getName();
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public int compareTo(SyntheticFacetablePropertyFTL that) {
            int modelComparison = this.containingPropDef.getModel().getName().compareTo(that.containingPropDef.getModel().getName());
            int classComparison = this.containingPropDef.getContainerClass().getName().compareTo(that.containingPropDef.getContainerClass().getName());
            int propComparison = this.containingPropDef.getName().compareTo(that.containingPropDef.getName());
            int displayNameComparison = this.displayName.compareTo(that.displayName);
            int result = modelComparison != 0 ? modelComparison : (classComparison != 0 ? classComparison : (propComparison != 0 ? propComparison : displayNameComparison));
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.containingPropDef == null ? 0 : this.containingPropDef.hashCode());
            result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
            result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
            result = 31 * result + (this.syntheticPropertyName == null ? 0 : this.syntheticPropertyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SyntheticFacetablePropertyFTL other = (SyntheticFacetablePropertyFTL)obj;
            if (this.containingPropDef == null ? other.containingPropDef != null : !this.containingPropDef.equals(other.containingPropDef)) {
                return false;
            }
            if (this.datatype == null ? other.datatype != null : !this.datatype.equals((Object)other.datatype)) {
                return false;
            }
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            return !(this.syntheticPropertyName == null ? other.syntheticPropertyName != null : !this.syntheticPropertyName.equals(other.syntheticPropertyName));
        }
    }

    public static class StandardFacetablePropertyFTL
    extends FacetablePropertyFTL<StandardFacetablePropertyFTL> {
        protected final PropertyDefinition propDef;
        protected final String displayName;

        public StandardFacetablePropertyFTL(PropertyDefinition propDef, String localisedTitle) {
            super(localisedTitle);
            this.propDef = propDef;
            this.displayName = this.getShortQname() + (String)(localisedTitle == null ? "" : " (" + localisedTitle + ")");
        }

        @Override
        public String getShortQname() {
            return this.propDef.getName().getPrefixString();
        }

        @Override
        public QName getQname() {
            return this.propDef.getName();
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public QName getContainerClassType() {
            return this.propDef.getContainerClass().getName();
        }

        @Override
        public QName getDataType() {
            return this.propDef.getDataType().getName();
        }

        @Override
        public QName getModelQname() {
            return this.propDef.getModel().getName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StandardFacetablePropertyFTL other = (StandardFacetablePropertyFTL)obj;
            if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                return false;
            }
            if (this.localisedTitle == null ? other.localisedTitle != null : !this.localisedTitle.equals(other.localisedTitle)) {
                return false;
            }
            return !(this.propDef == null ? other.propDef != null : !this.propDef.equals(other.propDef));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
            result = 31 * result + (this.localisedTitle == null ? 0 : this.localisedTitle.hashCode());
            result = 31 * result + (this.propDef == null ? 0 : this.propDef.hashCode());
            return result;
        }

        @Override
        public int compareTo(StandardFacetablePropertyFTL that) {
            int modelComparison = this.propDef.getModel().getName().compareTo(that.propDef.getModel().getName());
            int classComparison = this.propDef.getContainerClass().getName().compareTo(that.propDef.getContainerClass().getName());
            int propComparison = this.propDef.getName().compareTo(that.propDef.getName());
            int result = modelComparison != 0 ? modelComparison : (classComparison != 0 ? classComparison : propComparison);
            return result;
        }
    }
}

