/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.people;

import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.MemberOfSite;
import org.alfresco.rest.api.people.PeopleEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="sites", entityResource=PeopleEntityResource.class, title="Person Sites")
public class PersonSitesRelation
implements RelationshipResourceAction.Read<MemberOfSite>,
RelationshipResourceAction.ReadById<MemberOfSite>,
RelationshipResourceAction.Delete,
InitializingBean {
    private static final Log logger = LogFactory.getLog(PersonSitesRelation.class);
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
    }

    @Override
    @WebApiDescription(title="A paged list of the person's site memberships.")
    public CollectionWithPagingInfo<MemberOfSite> readAll(String personId, Parameters parameters) {
        return this.sites.getSites(personId, parameters);
    }

    @Override
    @WebApiDescription(title="Site membership information for 'personId' in 'siteId'.")
    public MemberOfSite readById(String personId, String siteId, Parameters parameters) {
        return this.sites.getMemberOfSite(personId, siteId);
    }

    @Override
    public void delete(String personId, String siteId, Parameters parameters) {
        this.sites.removeSiteMember(personId, siteId);
    }
}

