/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Comments;
import org.alfresco.rest.api.model.Comment;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.WebApiParameters;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="comments", entityResource=NodesEntityResource.class, title="Document or folder comments")
public class NodeCommentsRelation
implements RelationshipResourceAction.Read<Comment>,
RelationshipResourceAction.Create<Comment>,
RelationshipResourceAction.Update<Comment>,
RelationshipResourceAction.Delete,
InitializingBean {
    private Comments comments;

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"comments", (Object)this.comments);
    }

    @Override
    @WebApiDescription(title="Creates comments for the node 'nodeId'.")
    public List<Comment> create(String nodeId, List<Comment> entity, Parameters parameters) {
        ArrayList<Comment> result = new ArrayList<Comment>(entity.size());
        for (Comment comment : entity) {
            result.add(this.comments.createComment(nodeId, comment));
        }
        return result;
    }

    @Override
    @WebApiDescription(title="Returns a paged list of comments for the document/folder identified by nodeId, sorted chronologically with the newest first.")
    public CollectionWithPagingInfo<Comment> readAll(String nodeId, Parameters parameters) {
        return this.comments.getComments(nodeId, parameters.getPaging(), parameters.getInclude());
    }

    @Override
    @WebApiDescription(title="Updates the comment with the given id.")
    public Comment update(String nodeId, Comment entity, Parameters parameters) {
        return this.comments.updateComment(nodeId, entity);
    }

    @Override
    @WebApiDescription(title="Delete the comment with the given commentNodeId.")
    @WebApiParameters(value={@WebApiParam(name="nodeId", title="The unique id of the parent Node being addressed", description="A single node id"), @WebApiParam(name="commentNodeId", title="The unique id of the comment Node being addressed", description="A single node id")})
    public void delete(String nodeId, String commentNodeId, Parameters parameters) {
        this.comments.deleteComment(nodeId, commentNodeId);
    }
}

