/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.ArgumentTypeDescription;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.DeclarativeRegistry;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.DescriptionImpl;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.NegotiatedFormat;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.TransactionParameters;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpMethod;

public class PublicApiDeclarativeRegistry
extends DeclarativeRegistry {
    private WebScript getNetworksWebScript;
    private WebScript getNetworkWebScript;
    private Container container;
    private ResourceLocator locator;

    public void setLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public void setGetNetworksWebScript(WebScript getNetworksWebScript) {
        this.getNetworksWebScript = getNetworksWebScript;
    }

    public void setGetNetworkWebScript(WebScript getNetworkWebScript) {
        this.getNetworkWebScript = getNetworkWebScript;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        this.container = container;
    }

    public Match findWebScript(String method, String uri) {
        Match match;
        HttpMethod httpMethod = HttpMethod.valueOf((String)method);
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            if (uri.equals("networks")) {
                HashMap<String, String> templateVars = new HashMap<String, String>();
                templateVars.put("apiScope", "public");
                templateVars.put("apiVersion", "1");
                templateVars.put("apiName", "networks");
                match = new Match("", templateVars, "", this.getNetworksWebScript);
            } else if (uri.equals("network")) {
                HashMap<String, String> templateVars = new HashMap<String, String>();
                templateVars.put("apiScope", "public");
                templateVars.put("apiVersion", "1");
                templateVars.put("apiName", "network");
                match = new Match("", templateVars, "", this.getNetworkWebScript);
            } else {
                match = super.findWebScript(method, uri);
                if (match == null) {
                    return null;
                }
                Map templateVars = match.getTemplateVars();
                ResourceWithMetadata rwm = this.getResourceWithMetadataOrNull(templateVars, httpMethod);
                if (rwm != null) {
                    boolean noAuth;
                    Class resAction = null;
                    Map<String, String> resourceVars = this.locator.parseTemplateVars(templateVars);
                    String entityId = resourceVars.get("entityId");
                    String relationshipId = resourceVars.get("relationshipId");
                    switch (rwm.getMetaData().getType()) {
                        case ENTITY: {
                            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                                if (!EntityResourceAction.ReadById.class.isAssignableFrom(rwm.getResource().getClass())) break;
                                resAction = EntityResourceAction.ReadById.class;
                                break;
                            }
                            if (!EntityResourceAction.Read.class.isAssignableFrom(rwm.getResource().getClass())) break;
                            resAction = EntityResourceAction.Read.class;
                            break;
                        }
                        case PROPERTY: {
                            if (!StringUtils.isNotBlank((CharSequence)entityId)) break;
                            if (BinaryResourceAction.Read.class.isAssignableFrom(rwm.getResource().getClass())) {
                                resAction = BinaryResourceAction.Read.class;
                                break;
                            }
                            if (!RelationshipResourceBinaryAction.Read.class.isAssignableFrom(rwm.getResource().getClass())) break;
                            resAction = RelationshipResourceBinaryAction.Read.class;
                            break;
                        }
                        case RELATIONSHIP: {
                            if (StringUtils.isNotBlank((CharSequence)relationshipId)) {
                                if (!RelationshipResourceAction.ReadById.class.isAssignableFrom(rwm.getResource().getClass())) break;
                                resAction = RelationshipResourceAction.ReadById.class;
                                break;
                            }
                            if (!RelationshipResourceAction.Read.class.isAssignableFrom(rwm.getResource().getClass())) break;
                            resAction = RelationshipResourceAction.Read.class;
                            break;
                        }
                    }
                    boolean bl = noAuth = resAction != null && rwm.getMetaData().isNoAuth(resAction);
                    if (noAuth) {
                        match = this.overrideMatch(match);
                    }
                }
            }
        } else if (HttpMethod.POST.equals((Object)httpMethod)) {
            ResourceWithMetadata rwm;
            match = super.findWebScript(method, uri);
            if (match != null && (rwm = this.getResourceWithMetadataOrNull(match.getTemplateVars(), httpMethod)) != null) {
                Class resAction = null;
                Boolean noAuth = null;
                switch (rwm.getMetaData().getType()) {
                    case ENTITY: {
                        if (EntityResourceAction.Create.class.isAssignableFrom(rwm.getResource().getClass())) {
                            resAction = EntityResourceAction.Create.class;
                            break;
                        }
                        if (!EntityResourceAction.CreateWithResponse.class.isAssignableFrom(rwm.getResource().getClass())) break;
                        resAction = EntityResourceAction.CreateWithResponse.class;
                        break;
                    }
                    case RELATIONSHIP: {
                        if (RelationshipResourceAction.Create.class.isAssignableFrom(rwm.getResource().getClass())) {
                            resAction = RelationshipResourceAction.Create.class;
                            break;
                        }
                        if (!RelationshipResourceAction.CreateWithResponse.class.isAssignableFrom(rwm.getResource().getClass())) break;
                        resAction = RelationshipResourceAction.CreateWithResponse.class;
                        break;
                    }
                    case OPERATION: {
                        noAuth = rwm.getMetaData().isNoAuth(null);
                        break;
                    }
                }
                if (noAuth == null) {
                    noAuth = resAction != null && rwm.getMetaData().isNoAuth(resAction);
                }
                if (noAuth.booleanValue()) {
                    match = this.overrideMatch(match);
                }
            }
        } else {
            match = super.findWebScript(method, uri);
        }
        if (match == null) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{uri});
        }
        return match;
    }

    private ResourceWithMetadata getResourceWithMetadataOrNull(Map<String, String> templateVars, HttpMethod method) {
        if (templateVars.get("apiName") != null) {
            Api api = ApiAssistant.determineApi(templateVars);
            return this.locator.locateResource(api, templateVars, method);
        }
        return null;
    }

    private Match overrideMatch(final Match match) {
        WebScript noAuthWebScriptWrapper = new WebScript(){

            public void init(Container container, Description description) {
                match.getWebScript().init(container, description);
            }

            public Description getDescription() {
                final Description d = match.getWebScript().getDescription();
                return new Description(){

                    public String getStorePath() {
                        return d.getStorePath();
                    }

                    public String getScriptPath() {
                        return d.getScriptPath();
                    }

                    public Path getPackage() {
                        return d.getPackage();
                    }

                    public String getDescPath() {
                        return d.getDescPath();
                    }

                    public InputStream getDescDocument() throws IOException {
                        return d.getDescDocument();
                    }

                    public String getKind() {
                        return d.getKind();
                    }

                    public Set<String> getFamilys() {
                        return d.getFamilys();
                    }

                    public Description.RequiredAuthentication getRequiredAuthentication() {
                        return Description.RequiredAuthentication.none;
                    }

                    public String getRunAs() {
                        return d.getRunAs();
                    }

                    public Description.RequiredTransaction getRequiredTransaction() {
                        return d.getRequiredTransaction();
                    }

                    public Description.RequiredTransactionParameters getRequiredTransactionParameters() {
                        return d.getRequiredTransactionParameters();
                    }

                    public Description.RequiredCache getRequiredCache() {
                        return d.getRequiredCache();
                    }

                    public String getMethod() {
                        return d.getMethod();
                    }

                    public String[] getURIs() {
                        return d.getURIs();
                    }

                    public Description.FormatStyle getFormatStyle() {
                        return d.getFormatStyle();
                    }

                    public String getDefaultFormat() {
                        return d.getDefaultFormat();
                    }

                    public NegotiatedFormat[] getNegotiatedFormats() {
                        return d.getNegotiatedFormats();
                    }

                    public Map<String, Serializable> getExtensions() {
                        return d.getExtensions();
                    }

                    public Description.Lifecycle getLifecycle() {
                        return d.getLifecycle();
                    }

                    public boolean getMultipartProcessing() {
                        return d.getMultipartProcessing();
                    }

                    public void setMultipartProcessing(boolean b) {
                        d.setMultipartProcessing(b);
                    }

                    public ArgumentTypeDescription[] getArguments() {
                        return d.getArguments();
                    }

                    public TypeDescription[] getRequestTypes() {
                        return d.getRequestTypes();
                    }

                    public TypeDescription[] getResponseTypes() {
                        return d.getResponseTypes();
                    }

                    public String getId() {
                        return d.getId();
                    }

                    public String getShortName() {
                        return d.getShortName();
                    }

                    public String getDescription() {
                        return d.getDescription();
                    }
                };
            }

            public ResourceBundle getResources() {
                return match.getWebScript().getResources();
            }

            public void execute(WebScriptRequest webScriptRequest, WebScriptResponse webScriptResponse) throws IOException {
                match.getWebScript().execute(webScriptRequest, webScriptResponse);
            }

            public void setURLModelFactory(URLModelFactory urlModelFactory) {
                match.getWebScript().setURLModelFactory(urlModelFactory);
            }
        };
        return new Match(match.getTemplate(), match.getTemplateVars(), match.getPath(), noAuthWebScriptWrapper);
    }

    private void initWebScript(WebScript webScript, String name) {
        DescriptionImpl serviceDesc = new DescriptionImpl(name, name, name, name);
        serviceDesc.setRequiredAuthentication(Description.RequiredAuthentication.user);
        TransactionParameters transactionParameters = new TransactionParameters();
        transactionParameters.setRequired(Description.RequiredTransaction.required);
        transactionParameters.setCapability(Description.TransactionCapability.readonly);
        serviceDesc.setRequiredTransactionParameters((Description.RequiredTransactionParameters)transactionParameters);
        serviceDesc.setFormatStyle(Description.FormatStyle.argument);
        serviceDesc.setDefaultFormat("json");
        serviceDesc.setUris(new String[]{name});
        webScript.init(this.container, (Description)serviceDesc);
    }

    public void reset() {
        super.reset();
        this.initWebScript(this.getNetworksWebScript, "networks");
        this.initWebScript(this.getNetworkWebScript, "network");
    }
}

