/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.model.ModulePackage;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModulePackagesApiTest
extends AbstractBaseApiTest {
    public static final String MODULEPACKAGES = "modulepackages";
    protected String nonAdminUserName;

    @Override
    @Before
    public void setup() throws Exception {
        networkOne = null;
        this.nonAdminUserName = this.createUser("nonAdminUser" + System.currentTimeMillis(), "password", null);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.deleteUser(this.nonAdminUserName, networkOne);
    }

    @Test
    public void testAllModulePackages() throws Exception {
        this.setRequestContext(this.nonAdminUserName);
        HttpResponse response = this.getAll(MODULEPACKAGES, null, 200);
        Assert.assertNotNull((Object)response);
        PublicApiClient.ExpectedPaging paging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertNotNull((Object)paging);
        if (paging.getCount() > 0) {
            List<ModulePackage> modules = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), ModulePackage.class);
            Assert.assertNotNull(modules);
            Assert.assertEquals((long)paging.getCount().intValue(), (long)modules.size());
        }
    }

    @Test
    public void testSingleModulePackage() throws Exception {
        this.setRequestContext(this.nonAdminUserName);
        HttpResponse response = this.getSingle(MODULEPACKAGES, "NonSENSE_NOTFOUND", 404);
        Assert.assertNotNull((Object)response);
        response = this.getSingle(MODULEPACKAGES, "alfresco-simple-module", 200);
        Assert.assertNotNull((Object)response);
        ModulePackage simpleModule = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), ModulePackage.class);
        Assert.assertNotNull((Object)simpleModule);
        Assert.assertTrue((String)"Simple module must be the correct version", (boolean)"1.0.0-SNAPSHOT".equals(simpleModule.getVersion().toString()));
    }

    @Test
    public void testErrorUrls() throws Exception {
        this.setRequestContext(null);
        Map<String, String> params = this.createParams(null, null);
        HttpResponse response = this.publicApiClient.get(this.getScope(), "modulepackages/fred/blogs/king/kong/got/if/wrong", null, null, null, params);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"no-cache", (Object)response.getHeaders().get("Cache-Control"));
        Assert.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getHeaders().get("Content-Type"));
        PublicApiClient.ExpectedErrorResponse errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
    }

    @Override
    public String getScope() {
        return "private";
    }
}

