/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.client.data.PersonNetwork;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNetworks
extends EnterpriseTestApi {
    private List<RepoService.TestPerson> people = new ArrayList<RepoService.TestPerson>(3);
    private List<RepoService.TestNetwork> networks = new ArrayList<RepoService.TestNetwork>();
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private RepoService.TestNetwork network3;
    private RepoService.TestPerson person11;
    private RepoService.TestPerson person12;
    private RepoService.TestPerson person21;
    private RepoService.TestPerson person31;

    @Override
    @Before
    public void setup() {
        for (int i = 0; i < 2; ++i) {
            RepoService.TestNetwork network = this.repoService.createNetworkWithAlias("network" + i, true);
            network.create();
            this.networks.add(network);
        }
        RepoService.TestNetwork network = this.repoService.createNetworkWithAlias("cmisnew.test", true);
        network.create();
        this.networks.add(network);
        Assert.assertEquals((long)3L, (long)this.networks.size());
        this.network1 = this.networks.get(0);
        this.network2 = this.networks.get(1);
        this.network3 = this.networks.get(2);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestNetworks.this.network1.createUser();
                TestNetworks.this.people.add(person);
                person = TestNetworks.this.network1.createUser();
                TestNetworks.this.people.add(person);
                return null;
            }
        }, (String)this.network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestNetworks.this.network2.createUser();
                TestNetworks.this.people.add(person);
                return null;
            }
        }, (String)this.network2.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestNetworks.this.network3.createUser();
                TestNetworks.this.people.add(person);
                return null;
            }
        }, (String)this.network3.getId());
        Iterator<RepoService.TestPerson> peopleIt = this.people.iterator();
        this.person11 = peopleIt.next();
        this.person12 = peopleIt.next();
        this.person21 = peopleIt.next();
        this.person31 = peopleIt.next();
    }

    @Test
    public void testPersonNetworks() throws Exception {
        PersonNetwork pn;
        PublicApiClient.Paging expectedPaging;
        int skipCount;
        List<PersonNetwork> networkMemberships;
        PublicApiClient.Paging paging;
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        RepoService.TestNetwork testAccount = this.getTestFixture().getRandomNetwork();
        Iterator<RepoService.TestPerson> personIt = testAccount.getPeople().iterator();
        RepoService.TestPerson person = personIt.next();
        RequestContext rc = new RequestContext(null, person.getId());
        this.publicApiClient.setRequestContext(rc);
        HttpResponse response = this.publicApiClient.delete(null, null, null, null, null);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        PublicApiClient.ExpectedErrorResponse errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
        response = this.publicApiClient.put(null, null, null, null, null, null, null);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
        response = this.publicApiClient.post(null, null, null, null, null, null);
        Assert.assertEquals((long)404L, (long)response.getStatusCode());
        errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
        List<PersonNetwork> expectedNetworkMembers = person.getNetworkMemberships();
        int expectedTotal = expectedNetworkMembers.size();
        PublicApiClient.Paging paging2 = this.getPaging(0, Integer.MAX_VALUE, expectedTotal, expectedTotal);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", person.getId()));
        response = this.publicApiClient.index(this.createParams(paging2, null));
        PublicApiClient.ListResponse<PersonNetwork> resp = PersonNetwork.parseNetworkMembers(response.getJsonResponse());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.checkList(new ArrayList<PersonNetwork>(expectedNetworkMembers), paging2.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person21.getId()));
        List<Object> networksMemberships = Collections.emptyList();
        try {
            int skipCount2 = 0;
            int maxItems = 2;
            paging = this.getPaging(skipCount2, maxItems, networksMemberships.size(), networksMemberships.size());
            peopleProxy.getNetworkMemberships(this.person11.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            networksMemberships = this.person12.getNetworkMemberships();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person12.getId()));
            int skipCount3 = 0;
            int maxItems = 2;
            paging = this.getPaging(skipCount3, maxItems, networksMemberships.size(), networksMemberships.size());
            peopleProxy.getNetworkMemberships(this.person11.getId(), this.createParams(paging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        networksMemberships = this.person11.getNetworkMemberships();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
        int skipCount4 = 0;
        int maxItems = 2;
        paging = this.getPaging(skipCount4, maxItems, networksMemberships.size(), networksMemberships.size());
        PublicApiClient.ListResponse<PersonNetwork> resp2 = peopleProxy.getNetworkMemberships(this.person11.getId(), this.createParams(paging, null));
        this.checkList(networksMemberships.subList(skipCount4, skipCount4 + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp2);
        this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
        skipCount4 = 0;
        maxItems = Integer.MAX_VALUE;
        paging = this.getPaging(skipCount4, maxItems, networksMemberships.size(), networksMemberships.size());
        resp2 = peopleProxy.getNetworkMemberships("-me-", this.createParams(paging, null));
        this.checkList(networksMemberships.subList(skipCount4, skipCount4 + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp2);
        try {
            networkMemberships = this.person11.getNetworkMemberships();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            skipCount = 0;
            int maxItems2 = 2;
            expectedPaging = this.getPaging(skipCount, maxItems2, networkMemberships.size(), networkMemberships.size());
            peopleProxy.getNetworkMemberships("invalidUser", this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            networkMemberships = this.person11.getNetworkMemberships();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId(), GUID.generate()));
            skipCount = 0;
            int maxItems3 = 2;
            expectedPaging = this.getPaging(skipCount, maxItems3, networkMemberships.size(), networkMemberships.size());
            peopleProxy.getNetworkMemberships(this.person11.getId(), this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            networkMemberships = this.person11.getNetworkMemberships();
            Assert.assertTrue((networkMemberships.size() > 0 ? 1 : 0) != 0);
            PersonNetwork network = networkMemberships.get(0);
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.getNetworkMembership("invalidUser", network.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            networkMemberships = this.person11.getNetworkMemberships();
            Assert.assertTrue((networkMemberships.size() > 0 ? 1 : 0) != 0);
            PersonNetwork network = networkMemberships.get(0);
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId(), GUID.generate()));
            peopleProxy.getNetworkMembership(this.person11.getId(), network.getId());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.getNetworkMembership(this.person11.getId(), GUID.generate());
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pn = new PersonNetwork(GUID.generate());
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.create("people", this.person11.getId(), "networks", null, pn.toJSON().toString(), "Unable to POST to person networks");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pn = (PersonNetwork)networksMemberships.get(0);
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.create("people", this.person11.getId(), "networks", pn.getId(), pn.toJSON().toString(), "Unable to POST to a person network");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pn = new PersonNetwork(GUID.generate());
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.update("people", this.person11.getId(), "networks", null, pn.toJSON().toString(), "Unable to PUT person networks");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pn = (PersonNetwork)networksMemberships.get(0);
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.update("people", this.person11.getId(), "networks", pn.getId(), pn.toJSON().toString(), "Unable to PUT a person network");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.remove("people", this.person11.getId(), "networks", null, "Unable to DELETE person networks");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            pn = (PersonNetwork)networksMemberships.get(0);
            this.publicApiClient.setRequestContext(new RequestContext("-default-", this.person11.getId()));
            peopleProxy.remove("people", this.person11.getId(), "networks", pn.getId(), "Unable to DELETE a person network");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21.getId()));
            skipCount = 0;
            maxItems = 2;
            PublicApiClient.Paging expectedPaging2 = this.getPaging(skipCount, maxItems);
            peopleProxy.getNetworkMemberships(this.person11.getId(), this.createParams(expectedPaging2, null));
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testCLOUD1856() throws Exception {
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        this.publicApiClient.setRequestContext(new RequestContext(this.network3.getId(), this.person31.getId()));
        Person ret = peopleProxy.getPerson(this.person31.getId());
        this.person31.expected(ret);
    }

    @Test
    public void testALF20098() throws Exception {
        RepoService.TestNetwork testAccount = this.getTestFixture().getRandomNetwork();
        Iterator<RepoService.TestPerson> personIt = testAccount.getPeople().iterator();
        RepoService.TestPerson person = personIt.next();
        RequestContext rc = new RequestContext("-default-", person.getId());
        this.publicApiClient.setRequestContext(rc);
        HttpResponse response = this.publicApiClient.get("-default-", null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }
}

