/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.person;

import java.io.InputStream;
import java.util.ArrayList;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.person.UserCSVUploadPost;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class UserCSVUploadTest
extends BaseWebScriptTest {
    private static final String RESOURCE_PREFIX = "org/alfresco/repo/web/scripts/uploadcsv/";
    private DictionaryService dictionaryService;
    private UserCSVUploadPost uploadWebscript;

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        this.dictionaryService = (DictionaryService)ctx.getBean("DictionaryService");
        this.uploadWebscript = new UserCSVUploadPost();
        this.uploadWebscript.setDictionaryService(this.dictionaryService);
    }

    private InputStream getResourceAsStream(String fileName) {
        InputStream csvStream = UserCSVUploadTest.class.getClassLoader().getResourceAsStream(RESOURCE_PREFIX + fileName);
        UserCSVUploadTest.assertNotNull((Object)csvStream);
        return csvStream;
    }

    public void testProcessCVSUserTemplate() throws Exception {
        ArrayList users = new ArrayList();
        this.uploadWebscript.processCSVUpload(this.getResourceAsStream("userCSV.csv"), users);
        UserCSVUploadTest.assertEquals((int)2, (int)users.size());
    }

    public void testProcessCVSWithHeaderUserTemplate() throws Exception {
        ArrayList users = new ArrayList();
        this.uploadWebscript.processCSVUpload(this.getResourceAsStream("userCSV_header.csv"), users);
        UserCSVUploadTest.assertEquals((int)2, (int)users.size());
    }

    public void testProcessXLSUserTemplate() throws Exception {
        ArrayList users = new ArrayList();
        this.uploadWebscript.processXLSUpload(this.getResourceAsStream("userCSV.xls"), users);
        UserCSVUploadTest.assertEquals((int)2, (int)users.size());
    }

    public void testProcessXLSXUserTemplate() throws Exception {
        ArrayList users = new ArrayList();
        this.uploadWebscript.processXLSXUpload(this.getResourceAsStream("userCSV.xlsx"), users);
        UserCSVUploadTest.assertEquals((int)2, (int)users.size());
    }

    public void testProcessOtherUserTemplate() throws Exception {
        ArrayList users = new ArrayList();
        this.uploadWebscript.processUpload(this.getResourceAsStream("userCSV.csv1"), "userCSV.csv1", users);
        UserCSVUploadTest.assertEquals((int)2, (int)users.size());
    }
}

