/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class JacksonHelper
implements InitializingBean {
    private static Log logger = LogFactory.getLog(JacksonHelper.class);
    private Module module;
    private ObjectMapper objectMapper = null;
    private JsonEncoding encoding = JsonEncoding.UTF8;
    public static final String DEFAULT_FILTER_NAME = "defaultFilterName";

    public void setModule(Module module) {
        this.module = module;
    }

    public void afterPropertiesSet() throws Exception {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule(this.module);
        this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat DATE_FORMAT_ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        DATE_FORMAT_ISO8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.objectMapper.setDateFormat((DateFormat)DATE_FORMAT_ISO8601);
        this.objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }

    public void withWriter(OutputStream outStream, Writer writer) throws IOException {
        try {
            JsonGenerator generator = this.objectMapper.getFactory().createGenerator(outStream, this.encoding);
            writer.writeContents(generator, this.objectMapper);
        }
        catch (JsonGenerationException | JsonMappingException error) {
            throw new IOException("Failed to write Json output", error);
        }
    }

    public <T> T construct(Reader content, Class<T> requiredType) {
        ObjectReader reader = this.objectMapper.readerFor(requiredType);
        try {
            return (T)reader.readValue(content);
        }
        catch (IOException error) {
            throw new InvalidArgumentException("Could not read content from HTTP request body: " + error.getMessage());
        }
    }

    public <T> List<T> constructList(Reader content, Class<T> requiredType) {
        ObjectReader reader = this.objectMapper.readerFor(TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{requiredType}));
        try {
            List toReturn = (List)reader.readValue(content);
            if (toReturn == null || toReturn.isEmpty()) {
                throw new InvalidArgumentException("Could not read content from HTTP request body, the list is empty");
            }
            return toReturn;
        }
        catch (IOException error) {
            throw new InvalidArgumentException("Could not read content from HTTP request body: " + error.getMessage());
        }
    }

    public static interface Writer {
        public void writeContents(JsonGenerator var1, ObjectMapper var2) throws JsonGenerationException, JsonMappingException, IOException;
    }

    public static class ReturnAllBeanProperties
    extends SimpleBeanPropertyFilter {
    }
}

