/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.api.Audit;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.model.AuditApp;
import org.alfresco.rest.api.model.AuditEntry;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;

public class AuditImpl
implements Audit {
    private static final String DISABLED = "Audit is disabled system-wide";
    private static final String DEFAULT_USER = "-me-";
    private static final Set<String> LIST_AUDIT_ENTRY_EQUALS_QUERY_PROPERTIES = new HashSet<String>(Arrays.asList("createdByUser", "valuesKey", "valuesValue"));
    private static final Map<String, String> SORT_PARAMS_TO_NAMES;
    private AuditService auditService;
    private PersonService personService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private Nodes nodes;
    private People people;

    public void setPeople(People people) {
        this.people = people;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    private void checkEnabled() {
        if (!this.auditService.isAuditEnabled()) {
            throw new DisabledServiceException(DISABLED);
        }
    }

    @Override
    public AuditApp getAuditApp(String auditAppId, Parameters parameters) {
        HashMap result;
        List filteredParams;
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        AuditApp auditApp = new AuditApp(auditApplication.getKey().substring(1), auditApplication.getName(), auditApplication.isEnabled());
        if (!(parameters.getInclude().isEmpty() || (filteredParams = parameters.getInclude().stream().filter(p -> p.contains("max") || p.contains("min")).collect(Collectors.toList())).isEmpty() || (result = this.auditService.getAuditMinMaxByApp(auditApp.getName(), filteredParams)).isEmpty())) {
            auditApp.setMaxEntryId((Long)result.get("max"));
            auditApp.setMinEntryId((Long)result.get("min"));
        }
        return auditApp;
    }

    private AuditService.AuditApplication findAuditAppByIdOr404(String auditAppId) {
        AuditService.AuditApplication auditApplication = this.findAuditAppById(auditAppId);
        if (auditApplication == null) {
            throw new EntityNotFoundException(auditAppId);
        }
        return auditApplication;
    }

    private AuditService.AuditApplication findAuditAppById(String auditAppId) {
        AuditService.AuditApplication auditApp = null;
        Map auditApplicationsByName = this.auditService.getAuditApplications();
        if (auditApplicationsByName != null) {
            for (AuditService.AuditApplication auditApplication : auditApplicationsByName.values()) {
                if (!auditApplication.getKey().equals("/" + auditAppId)) continue;
                auditApp = auditApplication;
            }
        }
        return auditApp;
    }

    @Override
    public CollectionWithPagingInfo<AuditApp> getAuditApps(Paging paging) {
        this.checkEnabled();
        Map auditApplicationsByName = this.auditService.getAuditApplications();
        TreeSet audAppsName = new TreeSet(auditApplicationsByName.keySet());
        Iterator audAppsNameIt = audAppsName.iterator();
        int skipCount = paging.getSkipCount();
        int maxItems = paging.getMaxItems();
        int totalItems = audAppsName.size();
        int end = skipCount + maxItems;
        if (skipCount >= totalItems) {
            List empty = Collections.emptyList();
            return CollectionWithPagingInfo.asPaged(paging, empty, false, totalItems);
        }
        ArrayList<AuditApp> auditApps = new ArrayList<AuditApp>(totalItems);
        int count = 0;
        for (int i = 0; i < end && audAppsNameIt.hasNext(); ++i) {
            String auditAppName = (String)audAppsNameIt.next();
            if (i < skipCount) continue;
            ++count;
            AuditService.AuditApplication auditApplication = (AuditService.AuditApplication)auditApplicationsByName.get(auditAppName);
            auditApps.add(new AuditApp(auditApplication.getKey().substring(1), auditApplication.getName(), auditApplication.isEnabled()));
        }
        boolean hasMoreItems = skipCount + count < totalItems;
        return CollectionWithPagingInfo.asPaged(paging, auditApps, hasMoreItems, totalItems);
    }

    @Override
    public CollectionWithPagingInfo<AuditEntry> listAuditEntries(String auditAppId, Parameters parameters) {
        Integer totalItems;
        boolean omitTotalItems;
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        Pair<String, Boolean> sortProp = this.getAuditEntrySortProp(parameters);
        Boolean forward = true;
        if (sortProp != null && ((String)sortProp.getFirst()).equals("createdAt")) {
            forward = (Boolean)sortProp.getSecond();
        }
        List<Object> entriesAudit = new ArrayList();
        Query q = parameters.getQuery();
        Paging paging = parameters.getPaging();
        int skipCount = paging.getSkipCount();
        int maxItems = paging.getMaxItems();
        int limit = skipCount + maxItems + 1;
        if (q != null) {
            AuditEntryQueryWalker propertyWalker = new AuditEntryQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            entriesAudit = this.getQueryResultAuditEntries(auditApplication, propertyWalker, parameters.getInclude(), limit, forward);
        }
        entriesAudit.removeAll(Collections.singleton(null));
        int totalRetrievedItems = entriesAudit.size();
        int end = Math.min(limit - 1, totalRetrievedItems);
        boolean hasMoreItems = totalRetrievedItems > end;
        String omitTotalItemsParameter = parameters.getParameter("omitTotalItems");
        boolean bl = omitTotalItems = null != omitTotalItemsParameter && Boolean.parseBoolean(omitTotalItemsParameter);
        if (omitTotalItems) {
            totalItems = null;
        } else if (hasMoreItems) {
            if (q != null) {
                AuditEntryQueryWalker propertyWalker = new AuditEntryQueryWalker();
                QueryHelper.walk(q, propertyWalker);
                totalItems = this.getAuditEntriesCountByAppAndProperties(auditApplication, propertyWalker);
            } else {
                totalItems = this.getAuditEntriesCountByApp(auditApplication);
            }
        } else {
            totalItems = totalRetrievedItems;
        }
        entriesAudit = skipCount >= totalRetrievedItems ? Collections.emptyList() : entriesAudit.subList(skipCount, end);
        return CollectionWithPagingInfo.asPaged(paging, entriesAudit, hasMoreItems, totalItems);
    }

    private Pair<String, Boolean> getAuditEntrySortProp(Parameters parameters) {
        Pair sortProp = null;
        List<SortColumn> sortCols = parameters.getSorting();
        if (sortCols != null && sortCols.size() > 0) {
            if (sortCols.size() > 1) {
                throw new InvalidArgumentException("Multiple sort fields not allowed.");
            }
            SortColumn sortCol = sortCols.get(0);
            String sortPropName = SORT_PARAMS_TO_NAMES.get(sortCol.column);
            if (sortPropName == null) {
                throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
            }
            sortProp = new Pair((Object)sortPropName, (Object)(sortCol.asc ? Boolean.TRUE : Boolean.FALSE));
        }
        return sortProp;
    }

    public List<AuditEntry> getQueryResultAuditEntries(AuditService.AuditApplication auditApplication, AuditEntryQueryWalker propertyWalker, final List<String> includeParam, int maxItem, Boolean forward) {
        final ArrayList<AuditEntry> results = new ArrayList<AuditEntry>();
        final String auditAppId = auditApplication.getKey().substring(1);
        String auditApplicationName = auditApplication.getName();
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(forward.booleanValue());
        params.setApplicationName(auditApplicationName);
        params.setUser(propertyWalker.getCreatedByUser());
        Long fromId = propertyWalker.getFromId();
        Long toId = propertyWalker.getToId();
        this.validateWhereBetween(auditAppId, fromId, toId);
        Long fromTime = propertyWalker.getFromTime();
        Long toTime = propertyWalker.getToTime();
        this.validateWhereBetween(auditAppId, fromTime, toTime);
        params.setFromTime(fromTime);
        params.setToTime(toTime);
        params.setFromId(fromId);
        params.setToId(toId);
        if (propertyWalker.getValuesKey() != null && propertyWalker.getValuesValue() != null) {
            params.addSearchKey(propertyWalker.getValuesKey(), (Serializable)((Object)propertyWalker.getValuesValue()));
        }
        final HashMap mapUserInfo = new HashMap(10);
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return includeParam != null && includeParam.contains("values");
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException("Failed to retrieve audit data.", error);
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String userName, long time, Map<String, Serializable> values) {
                UserInfo userInfo = Node.lookupUserInfo(userName, mapUserInfo, AuditImpl.this.personService);
                AuditEntry auditEntry = new AuditEntry(entryId, auditAppId, userInfo, new Date(time), values);
                results.add(auditEntry);
                return true;
            }
        };
        this.auditService.auditQuery(callback, params, maxItem);
        return results;
    }

    @Override
    public AuditApp update(String auditAppId, AuditApp auditApp, Parameters parameters) {
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        if (auditApp.getIsEnabled().booleanValue() && !auditApplication.isEnabled()) {
            this.auditService.enableAudit(auditApplication.getName(), null);
        } else if (!auditApp.getIsEnabled().booleanValue() && auditApplication.isEnabled()) {
            this.auditService.disableAudit(auditApplication.getName(), null);
        }
        return new AuditApp(auditApplication.getKey().substring(1), auditApplication.getName(), auditApp.getIsEnabled());
    }

    @Override
    public AuditEntry getAuditEntry(final String auditAppId, long auditEntryId, Parameters parameters) {
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(auditApplication.getName());
        params.setFromId(Long.valueOf(auditEntryId));
        params.setToId(Long.valueOf(auditEntryId + 1L));
        final ArrayList<String> includeParam = new ArrayList<String>();
        if (parameters != null) {
            includeParam.addAll(parameters.getInclude());
        }
        includeParam.add("values");
        final ArrayList results = new ArrayList();
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return includeParam != null && includeParam.contains("values");
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException("Failed to retrieve audit data.", error);
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String userName, long time, Map<String, Serializable> values) {
                UserInfo userInfo = Node.lookupUserInfo(userName, new HashMap<String, UserInfo>(0), AuditImpl.this.personService);
                AuditEntry auditEntry = new AuditEntry(entryId, auditAppId, userInfo, new Date(time), values);
                results.add(auditEntry);
                return true;
            }
        };
        this.auditService.auditQuery(callback, params, 1);
        if (results.size() != 1) {
            throw new EntityNotFoundException("" + auditEntryId);
        }
        return (AuditEntry)results.get(0);
    }

    @Override
    public void deleteAuditEntry(String auditAppId, long auditEntryId, Parameters parameters) {
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        int deleted = this.auditService.clearAuditByIdRange(auditApplication.getName(), Long.valueOf(auditEntryId), Long.valueOf(auditEntryId + 1L));
        if (deleted != 1) {
            throw new EntityNotFoundException("" + auditEntryId);
        }
    }

    @Override
    public void deleteAuditEntries(String auditAppId, Parameters parameters) {
        this.checkEnabled();
        AuditService.AuditApplication auditApplication = this.findAuditAppByIdOr404(auditAppId);
        Query q = parameters.getQuery();
        if (q == null || q.getTree() == null) {
            throw new InvalidArgumentException("where clause is required to delete audit entries (" + auditAppId + ")");
        }
        DeleteAuditEntriesQueryWalker walker = new DeleteAuditEntriesQueryWalker();
        QueryHelper.walk(q, walker);
        Long fromId = walker.getFromId();
        Long toId = walker.getToId();
        this.validateWhereBetween(auditAppId, fromId, toId);
        Long fromTime = walker.getFromTime();
        Long toTime = walker.getToTime();
        this.validateWhereBetween(auditAppId, fromTime, toTime);
        if (fromId != null && fromTime != null) {
            throw new InvalidArgumentException("where clause is invalid - cannot specify both createdAt & id (" + auditAppId + ")");
        }
        if (fromId != null) {
            this.auditService.clearAuditByIdRange(auditApplication.getName(), fromId, toId);
        } else if (fromTime != null) {
            this.auditService.clearAudit(auditApplication.getName(), fromTime, toTime);
        }
    }

    private static long getTime(String iso8601String) {
        return ISO8601DateFormat.parse((String)iso8601String.replace(" ", "+")).getTime();
    }

    private void validateWhereBetween(String auditAppId, Long from, Long to) {
        if (from != null || to != null) {
            if (from == null || to == null) {
                throw new InvalidArgumentException("where BETWEEN is invalid - must contain range (" + auditAppId + ")");
            }
            if (from >= to) {
                throw new InvalidArgumentException("where BETWEEN is invalid - range start greater than end (" + auditAppId + ")");
            }
        }
    }

    @Override
    public CollectionWithPagingInfo<AuditEntry> listAuditEntriesByNodeId(String nodeId, Parameters parameters) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditImpl.this.checkEnabled();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        NodeRef nodeRef = this.nodes.validateNode(nodeId);
        List<Object> entriesAudit = new ArrayList();
        Pair<String, Boolean> sortProp = this.getAuditEntrySortProp(parameters);
        Boolean forward = true;
        if (sortProp != null && ((String)sortProp.getFirst()).equals("createdAt")) {
            forward = (Boolean)sortProp.getSecond();
        }
        Paging paging = parameters.getPaging();
        int skipCount = paging.getSkipCount();
        int maxItems = paging.getMaxItems();
        int limit = skipCount + maxItems + 1;
        Query q = parameters.getQuery();
        if (q != null) {
            AuditEntriesByNodeIdQueryWalker propertyWalker = new AuditEntriesByNodeIdQueryWalker();
            QueryHelper.walk(q, propertyWalker);
            entriesAudit = this.getQueryResultAuditEntriesByNodeRef(nodeRef, propertyWalker, parameters.getInclude(), forward, limit);
        }
        entriesAudit.removeAll(Collections.singleton(null));
        int totalItems = entriesAudit.size();
        if (skipCount >= totalItems) {
            List empty = Collections.emptyList();
            return CollectionWithPagingInfo.asPaged(paging, empty, false, totalItems);
        }
        int end = Math.min(limit - 1, totalItems);
        boolean hasMoreItems = totalItems > end;
        entriesAudit = entriesAudit.subList(skipCount, end);
        return CollectionWithPagingInfo.asPaged(paging, entriesAudit, hasMoreItems, totalItems);
    }

    private List<AuditEntry> getQueryResultAuditEntriesByNodeRef(NodeRef nodeRef, final AuditEntriesByNodeIdQueryWalker propertyWalker, final List<String> includeParam, final boolean forward, final int limit) {
        final ArrayList<AuditEntry> results = new ArrayList<AuditEntry>();
        final String auditAppId = "alfresco-access";
        final String auditApplicationName = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return AuditImpl.this.findAuditAppByIdOr404(auditAppId).getName();
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        final AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return includeParam != null && includeParam.contains("values");
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException("Failed to retrieve audit data.", error);
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String userName, long time, Map<String, Serializable> values) {
                UserInfo userInfo = Node.lookupUserInfo(userName, new HashMap<String, UserInfo>(0), AuditImpl.this.personService);
                AuditEntry auditEntry = new AuditEntry(entryId, auditAppId, userInfo, new Date(time), values);
                results.add(auditEntry);
                return true;
            }
        };
        final String nodePath = ISO9075.decode((String)this.nodeService.getPath(nodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService));
        final Long fromTime = propertyWalker.getFromTime();
        final Long toTime = propertyWalker.getToTime();
        this.validateWhereBetween(nodeRef.getId(), fromTime, toTime);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AuditQueryParameters pathParams = new AuditQueryParameters();
                pathParams.setForward(forward);
                pathParams.setUser(propertyWalker.getCreatedByUser());
                pathParams.setFromTime(fromTime);
                pathParams.setToTime(toTime);
                pathParams.setApplicationName(auditApplicationName);
                pathParams.addSearchKey("/" + auditAppId + "/transaction/path", (Serializable)((Object)nodePath));
                AuditImpl.this.auditService.auditQuery(callback, pathParams, limit);
                AuditQueryParameters copyFromPathParams = new AuditQueryParameters();
                copyFromPathParams.setForward(forward);
                copyFromPathParams.setUser(propertyWalker.getCreatedByUser());
                copyFromPathParams.setFromTime(fromTime);
                copyFromPathParams.setToTime(toTime);
                copyFromPathParams.setApplicationName(auditApplicationName);
                copyFromPathParams.addSearchKey("/" + auditAppId + "/transaction/copy/from/path", (Serializable)((Object)nodePath));
                AuditImpl.this.auditService.auditQuery(callback, copyFromPathParams, limit);
                AuditQueryParameters moveFromPathParams = new AuditQueryParameters();
                moveFromPathParams.setForward(forward);
                moveFromPathParams.setUser(propertyWalker.getCreatedByUser());
                moveFromPathParams.setFromTime(fromTime);
                moveFromPathParams.setToTime(toTime);
                moveFromPathParams.setApplicationName(auditApplicationName);
                moveFromPathParams.addSearchKey("/" + auditAppId + "/transaction/move/from/path", (Serializable)((Object)nodePath));
                AuditImpl.this.auditService.auditQuery(callback, moveFromPathParams, limit);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return results;
    }

    public int getAuditEntriesCountByApp(AuditService.AuditApplication auditApplication) {
        String applicationName = auditApplication.getKey().substring(1);
        return this.auditService.getAuditEntriesCountByApp(applicationName);
    }

    public int getAuditEntriesCountByAppAndProperties(AuditService.AuditApplication auditApplication, AuditEntryQueryWalker propertyWalker) {
        String applicationName = auditApplication.getName();
        AuditQueryParameters parameters = new AuditQueryParameters();
        parameters.setApplicationName(applicationName);
        parameters.setFromTime(propertyWalker.getFromTime());
        parameters.setToTime(propertyWalker.getToTime());
        parameters.setFromId(propertyWalker.getFromId());
        parameters.setToId(propertyWalker.getToId());
        parameters.setUser(propertyWalker.getCreatedByUser());
        return this.auditService.getAuditEntriesCountByAppAndProperties(applicationName, parameters);
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>(1);
        aMap.put("createdAt", "createdAt");
        SORT_PARAMS_TO_NAMES = Collections.unmodifiableMap(aMap);
    }

    private class AuditEntryQueryWalker
    extends MapBasedQueryWalker {
        private Long fromTime;
        private Long toTime;
        private Long fromId;
        private Long toId;

        public AuditEntryQueryWalker() {
            super(LIST_AUDIT_ENTRY_EQUALS_QUERY_PROPERTIES, null);
        }

        @Override
        public void and() {
        }

        @Override
        public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
            if (propertyName.equals("createdAt")) {
                this.fromTime = AuditImpl.getTime(firstValue);
                this.toTime = AuditImpl.getTime(secondValue) + 1L;
            }
            if (propertyName.equals("id")) {
                this.fromId = Long.valueOf(firstValue);
                this.toId = Long.valueOf(secondValue) + 1L;
            }
        }

        public Long getFromTime() {
            return this.fromTime;
        }

        public Long getToTime() {
            return this.toTime;
        }

        public String getCreatedByUser() {
            String propertyValue = this.getProperty("createdByUser", 8, String.class);
            if (propertyValue != null && propertyValue.equalsIgnoreCase(AuditImpl.DEFAULT_USER)) {
                propertyValue = AuditImpl.this.people.validatePerson(propertyValue);
            }
            return propertyValue;
        }

        public String getValuesKey() {
            return this.getProperty("valuesKey", 8, String.class);
        }

        public String getValuesValue() {
            return this.getProperty("valuesValue", 8, String.class);
        }

        public Long getFromId() {
            return this.fromId;
        }

        public Long getToId() {
            return this.toId;
        }
    }

    private static class DeleteAuditEntriesQueryWalker
    extends MapBasedQueryWalker {
        private Long fromTime;
        private Long toTime;
        private Long fromId;
        private Long toId;

        public DeleteAuditEntriesQueryWalker() {
            super(null, null);
        }

        @Override
        public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
            if (propertyName.equals("createdAt")) {
                this.fromTime = AuditImpl.getTime(firstValue);
                this.toTime = AuditImpl.getTime(secondValue) + 1L;
            }
            if (propertyName.equals("id")) {
                this.fromId = Long.valueOf(firstValue);
                this.toId = Long.valueOf(secondValue) + 1L;
            }
        }

        public Long getFromTime() {
            return this.fromTime;
        }

        public Long getToTime() {
            return this.toTime;
        }

        public Long getFromId() {
            return this.fromId;
        }

        public Long getToId() {
            return this.toId;
        }
    }

    private class AuditEntriesByNodeIdQueryWalker
    extends MapBasedQueryWalker {
        private Long fromTime;
        private Long toTime;

        public AuditEntriesByNodeIdQueryWalker() {
            super(new HashSet<String>(Arrays.asList("createdByUser")), null);
        }

        @Override
        public void and() {
        }

        @Override
        public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
            if (propertyName.equals("createdAt")) {
                this.fromTime = AuditImpl.getTime(firstValue);
                this.toTime = AuditImpl.getTime(secondValue) + 1L;
            }
        }

        public String getCreatedByUser() {
            String propertyValue = this.getProperty("createdByUser", 8, String.class);
            if (propertyValue != null && propertyValue.equalsIgnoreCase(AuditImpl.DEFAULT_USER)) {
                propertyValue = AuditImpl.this.people.validatePerson(propertyValue);
            }
            return propertyValue;
        }

        public Long getFromTime() {
            return this.fromTime;
        }

        public Long getToTime() {
            return this.toTime;
        }
    }
}

