/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class LockMethod
extends WebDAVMethod {
    public static final String EMPTY_NS = "";
    private static Timer timer = new Timer(true);
    protected int m_timeoutDuration = 86400;
    protected LockInfo lockInfo = new LockInfoImpl();
    protected boolean createExclusive;
    protected String lockToken = null;

    protected final boolean hasLockToken() {
        if (this.m_conditions != null) {
            for (WebDAVMethod.Condition condition : this.m_conditions) {
                if (condition.getLockTokensMatch().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected final int getLockTimeout() {
        return this.m_timeoutDuration;
    }

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.m_userAgent = this.m_request.getHeader("User-Agent");
        this.parseDepthHeader();
        if (this.m_depth != 0 && this.m_depth != -1) {
            throw new WebDAVServerException(500);
        }
        this.parseIfHeader();
        String strTimeout = this.m_request.getHeader("Timeout");
        if (strTimeout != null && strTimeout.startsWith("Second-")) {
            try {
                int idx = strTimeout.indexOf(" ");
                strTimeout = idx != -1 ? strTimeout.substring("Second-".length(), idx) : strTimeout.substring("Second-".length());
                this.m_timeoutDuration = Integer.parseInt(strTimeout);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse Timeout header: " + strTimeout));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Timeout=" + this.getLockTimeout() + ", depth=" + this.getDepth()));
        }
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
        if (this.m_request.getContentLength() == -1) {
            return;
        }
        Document body = this.getRequestBodyAsDocument();
        if (body != null) {
            block0: for (Node currentNode = body.getDocumentElement().getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (!(currentNode instanceof Element) || !"DAV:".equals(((Element)currentNode).getNamespaceURI()) || !"lockscope".equals(((Element)currentNode).getLocalName())) continue;
                for (Node propertiesNode = currentNode.getFirstChild(); propertiesNode != null; propertiesNode = propertiesNode.getNextSibling()) {
                    if (!(propertiesNode instanceof Element) || !"DAV:".equals(((Element)propertiesNode).getNamespaceURI())) continue;
                    this.createExclusive = "exclusive".equals(propertiesNode.getLocalName());
                    break block0;
                }
                break;
            }
            if (!this.createExclusive) {
                throw new WebDAVServerException(412);
            }
        }
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        RuleService ruleService = this.getServiceRegistry().getRuleService();
        try {
            ruleService.disableRuleType("update");
            this.attemptLock();
        }
        finally {
            ruleService.enableRuleType("update");
        }
    }

    protected void attemptLock() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        final String path = this.getPath();
        NodeRef rootNodeRef = this.getRootNodeRef();
        final String userName = this.getDAVHelper().getAuthenticationService().getCurrentUserName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locking node: \n   user: " + userName + "\n   path: " + path));
        }
        FileInfo lockNodeInfo = null;
        try {
            lockNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.getPath());
        }
        catch (FileNotFoundException e) {
            String[] splitPath;
            if (this.m_conditions != null) {
                for (WebDAVMethod.Condition condition : this.m_conditions) {
                    LinkedList<String> lockTolensMatch = condition.getLockTokensMatch();
                    LinkedList<String> etagsMatch = condition.getETagsMatch();
                    if ((this.m_request.getContentLength() != -1 || lockTolensMatch == null || lockTolensMatch.isEmpty()) && (etagsMatch == null || etagsMatch.isEmpty())) continue;
                    throw new WebDAVServerException(403);
                }
            }
            if ((splitPath = this.getDAVHelper().splitPath(path))[1].length() == 0) {
                throw new WebDAVServerException(500);
            }
            FileInfo dirInfo = null;
            List<String> dirPathElements = this.getDAVHelper().splitAllPaths(splitPath[0]);
            dirInfo = dirPathElements.size() == 0 ? fileFolderService.getFileInfo(this.getRootNodeRef()) : FileFolderUtil.makeFolders((FileFolderService)fileFolderService, (NodeRef)rootNodeRef, dirPathElements, (QName)ContentModel.TYPE_FOLDER);
            if (dirInfo == null) {
                throw new WebDAVServerException(500);
            }
            lockNodeInfo = this.createNode(dirInfo.getNodeRef(), splitPath[1], ContentModel.TYPE_CONTENT);
            int lockTimeout = this.getLockTimeout();
            if (lockTimeout > 0 && !this.getNodeService().hasAspect(lockNodeInfo.getNodeRef(), ContentModel.ASPECT_WEBDAV_NO_CONTENT)) {
                final NodeRef nodeRef = lockNodeInfo.getNodeRef();
                this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT, null);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                            public Void doWork() throws Exception {
                                block5: {
                                    try {
                                        if (LockMethod.this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT)) {
                                            LockMethod.this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                                                public String execute() throws Throwable {
                                                    LockMethod.this.getNodeService().deleteNode(nodeRef);
                                                    if (WebDAVMethod.logger.isDebugEnabled()) {
                                                        WebDAVMethod.logger.debug((Object)("Timer DELETE " + path));
                                                    }
                                                    return null;
                                                }
                                            }, false, true);
                                        } else if (WebDAVMethod.logger.isDebugEnabled()) {
                                            WebDAVMethod.logger.debug((Object)("Timer IGNORE " + path));
                                        }
                                    }
                                    catch (InvalidNodeRefException e) {
                                        if (!WebDAVMethod.logger.isDebugEnabled()) break block5;
                                        WebDAVMethod.logger.debug((Object)("Timer DOES NOT EXIST " + path));
                                    }
                                }
                                return null;
                            }
                        }, (String)userName);
                    }
                }, lockTimeout * 1000);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Timer START in " + lockTimeout + " seconds " + path));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created new node for lock: \n   path: " + path + "\n   node: " + String.valueOf(lockNodeInfo)));
            }
            this.m_response.setStatus(201);
        }
        if (this.hasLockToken()) {
            this.lockInfo = this.checkNode(lockNodeInfo);
            if (!this.lockInfo.isLocked() && this.m_request.getContentLength() == -1) {
                throw new WebDAVServerException(400);
            }
            this.createExclusive = "exclusive".equals(this.lockInfo.getScope());
            this.refreshLock(lockNodeInfo, userName);
        } else {
            this.lockInfo = this.checkNode(lockNodeInfo, true, this.createExclusive);
            this.createLock(lockNodeInfo, userName);
        }
        this.m_response.setHeader("Lock-Token", "<" + WebDAV.makeLockToken(lockNodeInfo.getNodeRef(), userName) + ">");
        this.m_response.setHeader("Content-Type", "text/xml; charset=UTF-8");
        this.generateResponse(lockNodeInfo, userName);
    }

    protected FileInfo createNode(NodeRef parentNodeRef, String name, QName typeQName) {
        return this.getFileFolderService().create(parentNodeRef, name, ContentModel.TYPE_CONTENT);
    }

    protected final void createLock(FileInfo lockNode, String userName) throws WebDAVServerException {
        if (!this.createExclusive) {
            throw new WebDAVServerException(412);
        }
        this.lockToken = WebDAV.makeLockToken(lockNode.getNodeRef(), userName);
        this.lockInfo.setExclusiveLockToken(this.lockToken);
        this.lockInfo.setDepth(WebDAV.getDepthName(this.m_depth));
        this.lockInfo.setScope("exclusive");
        this.lockInfo.setOwner(userName);
        this.getDAVLockService().lock(lockNode.getNodeRef(), this.lockInfo, this.getLockTimeout());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locked node " + String.valueOf(lockNode) + ": " + String.valueOf(this.lockInfo)));
        }
    }

    protected final void refreshLock(FileInfo lockNode, String userName) throws WebDAVServerException {
        if (this.createExclusive) {
            this.lockInfo.setTimeoutSeconds(this.getLockTimeout());
            this.getDAVLockService().lock(lockNode.getNodeRef(), this.lockInfo);
        }
    }

    protected void generateResponse(FileInfo lockNodeInfo, String userName) throws Exception {
        String lt;
        String scope;
        if (this.lockToken != null) {
            scope = this.createExclusive ? "exclusive" : "shared";
            lt = this.lockToken;
        } else {
            scope = this.lockInfo.getScope();
            lt = this.lockInfo.getExclusiveLockToken();
        }
        String owner = this.lockInfo.getOwner();
        Date expiry = this.lockInfo.getExpires();
        XMLWriter xml = this.createXMLWriter();
        xml.startDocument();
        String nsdec = this.generateNamespaceDeclarations(null);
        xml.startElement("D", "prop" + nsdec, "D:prop" + nsdec, (Attributes)this.getDAVHelper().getNullAttributes());
        this.generateLockDiscoveryXML(xml, lockNodeInfo, false, scope, WebDAV.getDepthName(this.m_depth), lt, owner, expiry);
        xml.endElement("D", "prop", "D:prop");
        this.flushXML(xml);
    }

    @Override
    protected String generateNamespaceDeclarations(HashMap<String, String> nameSpaces) {
        StringBuilder ns = new StringBuilder();
        ns.append(" ");
        ns.append("xmlns");
        ns.append(":");
        ns.append("D");
        ns.append("=\"");
        ns.append("DAV:");
        ns.append("\"");
        if (nameSpaces != null) {
            for (String strNamespaceUri : nameSpaces.keySet()) {
                String strNamespaceName = nameSpaces.get(strNamespaceUri);
                ns.append(" ").append("xmlns").append(":").append(strNamespaceName).append("=\"");
                ns.append(strNamespaceUri).append("\" ");
            }
        }
        return ns.toString();
    }
}

