/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.config.OpenSearchConfigElement;
import org.alfresco.web.app.servlet.HTTPProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class SearchProxy
extends AbstractWebScript
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(SearchProxy.class);
    protected FormatRegistry formatRegistry;
    protected ConfigService configService;
    protected OpenSearchConfigElement searchConfig;
    protected String proxyPath;

    public void setFormatRegistry(FormatRegistry formatRegistry) {
        this.formatRegistry = formatRegistry;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void afterPropertiesSet() throws Exception {
        Config config = this.configService.getConfig((Object)"OpenSearch");
        this.searchConfig = (OpenSearchConfigElement)config.getConfigElement("opensearch");
        if (this.searchConfig == null) {
            throw new WebScriptException("OpenSearch configuration not found");
        }
        OpenSearchConfigElement.ProxyConfig proxyConfig = this.searchConfig.getProxy();
        if (proxyConfig == null) {
            throw new WebScriptException("OpenSearch proxy configuration not found");
        }
        this.proxyPath = proxyConfig.getUrl();
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String extensionPath = req.getExtensionPath();
        String[] extensionPaths = extensionPath.split("/");
        if (extensionPaths.length != 2) {
            throw new WebScriptException("OpenSearch engine has not been specified as /{engine}/{format}");
        }
        String engine = extensionPaths[0];
        OpenSearchConfigElement.EngineConfig engineConfig = this.searchConfig.getEngine(engine);
        if (engineConfig == null) {
            throw new WebScriptException("OpenSearch engine '" + engine + "' does not exist");
        }
        String format = extensionPaths[1];
        String mimetype = this.formatRegistry.getMimeType(null, format);
        if (mimetype == null) {
            throw new WebScriptException("Format '" + format + "' does not map to a registered mimetype");
        }
        Map<String, String> engineUrls = engineConfig.getUrls();
        Object engineUrl = engineUrls.get(mimetype);
        if (engineUrl == null) {
            throw new WebScriptException("Url mimetype '" + mimetype + "' does not exist for engine '" + engine + "'");
        }
        int engineUrlArgIdx = ((String)engineUrl).indexOf("?");
        if (engineUrlArgIdx != -1) {
            engineUrl = ((String)engineUrl).substring(0, engineUrlArgIdx);
        }
        if (req.getQueryString() != null) {
            engineUrl = (String)engineUrl + "?" + req.getQueryString();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping engine '" + engine + "' (mimetype '" + mimetype + "') to url '" + (String)engineUrl + "'"));
        }
        if (!(res.getRuntime() instanceof WebScriptServletRuntime)) {
            throw new WebScriptException("Search Proxy must be executed in HTTP Servlet environment");
        }
        HttpServletResponse servletRes = WebScriptServletRuntime.getHttpServletResponse((WebScriptResponse)res);
        SearchEngineHttpProxy proxy = new SearchEngineHttpProxy(req.getServerPath() + req.getServiceContextPath(), engine, (String)engineUrl, servletRes, Collections.singletonMap("User-Agent", req.getHeader("User-Agent")));
        proxy.service();
    }

    public String createUrl(OpenSearchConfigElement.EngineConfig engine, String mimetype) {
        String proxy;
        Map<String, String> urls = engine.getUrls();
        String url = urls.get(mimetype);
        if (url != null && (proxy = engine.getProxy()) != null && !mimetype.equals("application/opensearchdescription+xml")) {
            url = this.createUrl(proxy, url, mimetype);
        }
        return url;
    }

    public String createUrl(String engine, String url, String mimetype) {
        String format = this.formatRegistry.getFormat(null, mimetype);
        if (format == null) {
            throw new WebScriptException("Mimetype '" + mimetype + "' is not registered.");
        }
        String proxyUrl = null;
        int argIdx = url.indexOf("?");
        proxyUrl = argIdx == -1 ? this.proxyPath + "/" + engine + "/" + format : this.proxyPath + "/" + engine + "/" + format + url.substring(argIdx);
        return proxyUrl;
    }

    private class SearchEngineHttpProxy
    extends HTTPProxy {
        private static final String ATOM_NS_URI = "http://www.w3.org/2005/Atom";
        private static final String ATOM_NS_PREFIX = "atom";
        private static final String ATOM_LINK_XPATH = "atom:link[@rel=\"first\" or @rel=\"last\" or @rel=\"next\" or @rel=\"previous\" or @rel=\"self\" or @rel=\"alternate\"]";
        private String engine;
        private String rootPath;
        private Map<String, String> headers;

        public SearchEngineHttpProxy(String rootPath, String engine, String engineUrl, HttpServletResponse response, Map<String, String> headers) throws MalformedURLException {
            super((String)(engineUrl.startsWith("/") ? rootPath + engineUrl : engineUrl), response);
            this.engine = engine;
            this.rootPath = rootPath;
            this.headers = headers;
        }

        @Override
        protected void setRequestHeaders(URLConnection urlConnection) {
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        protected void writeResponse(InputStream input, OutputStream output) throws IOException {
            if (this.response.getContentType().startsWith("application/atom+xml") || this.response.getContentType().startsWith("application/rss+xml")) {
                SAXReader reader = new SAXReader();
                try {
                    Document document = reader.read(input);
                    Element rootElement = document.getRootElement();
                    XPath xpath = rootElement.createXPath(ATOM_LINK_XPATH);
                    HashMap<String, String> uris = new HashMap<String, String>();
                    uris.put(ATOM_NS_PREFIX, ATOM_NS_URI);
                    xpath.setNamespaceURIs(uris);
                    List nodes = xpath.selectNodes((Object)rootElement);
                    for (Element element : nodes) {
                        Object url;
                        Attribute hrefAttr = element.attribute("href");
                        String mimetype = element.attributeValue("type");
                        if (mimetype == null || mimetype.length() == 0) {
                            mimetype = "text/html";
                        }
                        if (((String)(url = SearchProxy.this.createUrl(this.engine, hrefAttr.getValue(), mimetype))).startsWith("/")) {
                            url = this.rootPath + (String)url;
                        }
                        hrefAttr.setValue((String)url);
                    }
                    OutputFormat outputFormat = OutputFormat.createPrettyPrint();
                    XMLWriter writer = new XMLWriter(output, outputFormat);
                    writer.write(rootElement);
                    writer.flush();
                }
                catch (DocumentException e) {
                    throw new IOException(e.toString());
                }
            } else {
                super.writeResponse(input, output);
            }
        }
    }
}

