/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ObjectStorageProps;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.DownloadsImpl;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DownloadsImplCheckArchiveStatusUnitTest {
    @InjectMocks
    private final DownloadsImpl downloads = new DownloadsImpl();
    @Mock
    private DownloadService downloadService;
    @Mock
    private ModuleService moduleService;
    @Mock
    private NodeService nodeService;
    @Mock
    private ContentService contentService;
    @Mock
    private Nodes nodes;
    @Mock
    private PermissionService permissionService;
    private final NodeRef contentNode1 = new NodeRef("://Content:/Node1");
    private final NodeRef contentNode2 = new NodeRef("://Content:/Node2");
    private final NodeRef contentNode3 = new NodeRef("://Content:/Node3");
    private final NodeRef contentNode4 = new NodeRef("://Content:/Node4");
    private final NodeRef contentNode5 = new NodeRef("://Content:/Node5");
    private final NodeRef contentNode6 = new NodeRef("://Content:/Node6");
    private final NodeRef folderParent1 = new NodeRef("://Folder:/Parent1");
    private final NodeRef folderParent2 = new NodeRef("://Folder:/Parent2");
    private final NodeRef folder1 = new NodeRef("://Folder:/1");
    private final NodeRef folder2 = new NodeRef("://Folder:/2");
    private final List<ChildAssociationRef> folderParent1ChildAssocs = List.of(new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent1, ContentModel.TYPE_CONTENT, this.contentNode3), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent1, ContentModel.TYPE_CONTENT, this.contentNode4), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent1, ContentModel.TYPE_CONTENT, this.contentNode5), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent1, ContentModel.TYPE_FOLDER, this.folder2), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent1, ContentModel.TYPE_FOLDER, this.folderParent2));
    private final List<ChildAssociationRef> folderParent2ChildAssocs = List.of(new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folderParent2, ContentModel.TYPE_FOLDER, this.folder1));
    private final List<ChildAssociationRef> folder1ChildAssocs = List.of(new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folder1, ContentModel.TYPE_CONTENT, this.contentNode1), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folder1, ContentModel.TYPE_CONTENT, this.contentNode5), new ChildAssociationRef(ContentModel.TYPE_FOLDER, this.folder1, ContentModel.TYPE_CONTENT, this.contentNode6));
    private final List<ChildAssociationRef> folder2ChildAssocs = List.of();
    private final Map<String, String> archivedProps = Map.of(ObjectStorageProps.X_ALF_ARCHIVED.getValue(), "true");
    private final Map<String, String> nonArchivedProps = Map.of(ObjectStorageProps.X_ALF_ARCHIVED.getValue(), "false");
    private final ModuleDetails mockDetails = new ModuleDetailsImpl("id", null, "title", "description");
    private final NodeRef[] nodeRefsToTest = new NodeRef[]{this.contentNode1, this.contentNode2, this.folderParent1, this.folder1};

    @Before
    public void setup() {
        Mockito.when((Object)this.nodeService.getType((NodeRef)ArgumentMatchers.any())).thenReturn((Object)ContentModel.TYPE_CONTENT);
        Mockito.when((Object)this.nodeService.getType(this.folderParent1)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.nodeService.getType(this.folderParent2)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.nodeService.getType(this.folder1)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.nodeService.getType(this.folder2)).thenReturn((Object)ContentModel.TYPE_FOLDER);
        Mockito.when((Object)this.nodeService.getChildAssocs(this.folderParent1)).thenReturn(this.folderParent1ChildAssocs);
        Mockito.when((Object)this.nodeService.getChildAssocs(this.folderParent2)).thenReturn(this.folderParent2ChildAssocs);
        Mockito.when((Object)this.nodeService.getChildAssocs(this.folder1)).thenReturn(this.folder1ChildAssocs);
        Mockito.when((Object)this.nodeService.getChildAssocs(this.folder2)).thenReturn(this.folder2ChildAssocs);
        Mockito.when((Object)this.moduleService.getModule("org_alfresco_integrations_S3Connector")).thenReturn((Object)this.mockDetails);
        NodeRef[] childNodeRefsExpectedFolderParent1 = new NodeRef[]{this.contentNode3, this.contentNode4, this.contentNode5, this.folder2, this.folderParent2};
        NodeRef[] childNodeRefsExpectedFolderParent2 = new NodeRef[]{this.folder1};
        NodeRef[] childNodeRefsExpectedFolder1 = new NodeRef[]{this.contentNode1, this.contentNode5, this.contentNode6};
        NodeRef[] childNodeRefsExpectedFolder2 = new NodeRef[]{};
        this.assertChildNodeRefMocks(this.folderParent1, childNodeRefsExpectedFolderParent1);
        this.assertChildNodeRefMocks(this.folderParent2, childNodeRefsExpectedFolderParent2);
        this.assertChildNodeRefMocks(this.folder1, childNodeRefsExpectedFolder1);
        this.assertChildNodeRefMocks(this.folder2, childNodeRefsExpectedFolder2);
    }

    @Test
    public void testAllPass() {
        Mockito.when((Object)this.contentService.getStorageProperties((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class))).thenReturn(this.nonArchivedProps);
        this.downloads.checkArchiveStatus(this.nodeRefsToTest, -1);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode1, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode2, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode3, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode4, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode5, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode6, ContentModel.TYPE_CONTENT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.contentService});
    }

    @Test
    public void testFirstItemArchived() {
        Mockito.when((Object)this.contentService.getStorageProperties(this.contentNode1, ContentModel.TYPE_CONTENT)).thenReturn(this.archivedProps);
        Assert.assertThrows(ArchivedIOException.class, () -> this.downloads.checkArchiveStatus(this.nodeRefsToTest, -1));
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode1, ContentModel.TYPE_CONTENT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.contentService});
    }

    @Test
    public void testContentNode3Archived() {
        Mockito.when((Object)this.contentService.getStorageProperties((NodeRef)ArgumentMatchers.any(NodeRef.class), (QName)ArgumentMatchers.any(QName.class))).thenReturn(this.nonArchivedProps);
        Mockito.when((Object)this.contentService.getStorageProperties(this.contentNode3, ContentModel.TYPE_CONTENT)).thenReturn(this.archivedProps);
        Assert.assertThrows(ArchivedIOException.class, () -> this.downloads.checkArchiveStatus(this.nodeRefsToTest, -1));
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode1, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode2, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode3, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode5, ContentModel.TYPE_CONTENT);
        ((ContentService)Mockito.verify((Object)this.contentService, (VerificationMode)Mockito.times((int)1))).getStorageProperties(this.contentNode6, ContentModel.TYPE_CONTENT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.contentService});
    }

    private void assertChildNodeRefMocks(NodeRef nodeRef, NodeRef[] expecteds) {
        Object[] actuals = (NodeRef[])this.nodeService.getChildAssocs(nodeRef).stream().map(childAssoc -> childAssoc.getChildRef()).toArray(NodeRef[]::new);
        Assert.assertArrayEquals((Object[])expecteds, (Object[])actuals);
    }
}

