/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.links.AbstractLinksWebScript;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LinkDelete
extends AbstractLinksWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String linkName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        LinkInfo link = this.linksService.getLink(site.getShortName(), linkName);
        if (link == null) {
            String message = "No link found with that name";
            throw new WebScriptException(404, message);
        }
        try {
            this.linksService.deleteLink(link);
        }
        catch (AccessDeniedException e) {
            String message = "You don't have permission to delete that link";
            throw new WebScriptException(403, message);
        }
        status.setCode(204);
        return model;
    }
}

