/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.dictionary.Facetable;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.rest.api.model.AbstractCustomClass;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelProperty;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.BaseCustomModelApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestCustomTypeAspect
extends BaseCustomModelApiTest {
    @Test
    public void testCreateCustomModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.ACTIVE);
        HttpResponse response = this.getSingle("cmm", modelName, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertNull((Object)returnedModel.getTypes());
        Assert.assertNull((Object)returnedModel.getAspects());
        response = this.getSingle("cmm", modelName + "?select=all", 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertNotNull((Object)returnedModel.getTypes());
        Assert.assertTrue((boolean)returnedModel.getTypes().isEmpty());
        Assert.assertNotNull((Object)returnedModel.getAspects());
        Assert.assertTrue((boolean)returnedModel.getAspects().isEmpty());
        Assert.assertNotNull((Object)returnedModel.getConstraints());
        Assert.assertTrue((boolean)returnedModel.getConstraints().isEmpty());
    }

    @Test
    public void testCreateAspectsAndTypes_ExistingModel() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        CustomAspect aspect = new CustomAspect();
        aspect.setName(aspectName);
        this.setRequestContext(this.nonAdminUserName);
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 403);
        this.setRequestContext(this.customModelAdmin);
        aspect.setParentName("cm:content");
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 409);
        aspect.setParentName(null);
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 201);
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 409);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/aspects", aspect.getName(), 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        this.compareCustomTypesAspects((AbstractCustomClass)aspect, (AbstractCustomClass)returnedAspect, "prefixedName");
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + aspectName), (Object)returnedAspect.getPrefixedName());
        String typeName = "testType" + System.currentTimeMillis();
        CustomType type = new CustomType();
        type.setName(typeName);
        type.setDescription("test type Desc");
        type.setTitle("test type title");
        type.setParentName("cm:content");
        this.setRequestContext(this.nonAdminUserName);
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 403);
        this.setRequestContext(this.customModelAdmin);
        type.setParentName("cm:titled");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 409);
        type.setParentName("cm:content");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 201);
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 409);
        HttpResponse response2 = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomType.class);
        this.compareCustomTypesAspects((AbstractCustomClass)type, (AbstractCustomClass)returnedType, "prefixedName");
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + typeName), (Object)returnedType.getPrefixedName());
        CustomModelDefinition modelDef = this.getModelDefinition(modelName);
        Assert.assertNotNull((Object)modelDef);
        Collection importedNamespaces = modelDef.getImportedNamespaces();
        Assert.assertTrue((boolean)this.hasNamespaceUri(importedNamespaces, "http://www.alfresco.org/model/content/1.0"));
        Assert.assertTrue((boolean)this.hasNamespacePrefix(importedNamespaces, "cm"));
        CustomAspect aspect2 = new CustomAspect();
        aspect2.setName(typeName);
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect2), 409);
        CustomType type2 = new CustomType();
        type2.setName(aspectName);
        type2.setParentName("cm:content");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type2), 409);
    }

    @Test
    public void testCreateModel_WithAspectsAndTypes_Invalid() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String typeURL = "cmm/" + modelName + "/types";
        CustomType type = new CustomType();
        type.setName(null);
        type.setDescription("test type Desc");
        this.post(typeURL, RestApiUtil.toJsonAsString(type), 400);
        type.setName("prefix:someTypename");
        this.post(typeURL, RestApiUtil.toJsonAsString(type), 400);
        type.setName("");
        this.post(typeURL, RestApiUtil.toJsonAsString(type), 400);
        type.setName("testType<name");
        this.post(typeURL, RestApiUtil.toJsonAsString(type), 400);
        String aspectURL = "cmm/" + modelName + "/aspects";
        CustomAspect aspect = new CustomAspect();
        aspect.setName(null);
        aspect.setTitle("test aspect title");
        this.post(aspectURL, RestApiUtil.toJsonAsString(aspect), 400);
        aspect.setName("prefix:someAspectname");
        this.post(aspectURL, RestApiUtil.toJsonAsString(aspect), 400);
        aspect.setName("");
        this.post(aspectURL, RestApiUtil.toJsonAsString(aspect), 400);
        aspect.setName("testType>name");
        this.post(aspectURL, RestApiUtil.toJsonAsString(aspect), 400);
    }

    @Test
    public void testCreateAspectsAndTypesWithProperties() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect1" + System.currentTimeMillis();
        CustomAspect aspect = new CustomAspect();
        aspect.setName(aspectName);
        String aspectPropName = "testAspect1Prop1" + System.currentTimeMillis();
        CustomModelProperty aspectProp = new CustomModelProperty();
        aspectProp.setName(aspectPropName);
        aspectProp.setTitle("property title");
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(aspectProp);
        aspect.setProperties(props);
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 201);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/aspects", aspect.getName(), 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        this.compareCustomTypesAspects((AbstractCustomClass)aspect, (AbstractCustomClass)returnedAspect, "prefixedName", "dataType", "indexTokenisationMode");
        Assert.assertEquals((long)1L, (long)returnedAspect.getProperties().size());
        CustomModelProperty customModelProperty = (CustomModelProperty)returnedAspect.getProperties().get(0);
        Assert.assertEquals((Object)aspectPropName, (Object)customModelProperty.getName());
        Assert.assertEquals((Object)"property title", (Object)customModelProperty.getTitle());
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + aspectPropName), (Object)customModelProperty.getPrefixedName());
        Assert.assertEquals((String)"Default data type is 'd:text'.", (Object)"d:text", (Object)customModelProperty.getDataType());
        Assert.assertTrue((boolean)customModelProperty.isIndexed());
        Assert.assertEquals((Object)Facetable.UNSET, (Object)customModelProperty.getFacetable());
        Assert.assertEquals((Object)IndexTokenisationMode.TRUE, (Object)customModelProperty.getIndexTokenisationMode());
        String typeName = "testType1" + System.currentTimeMillis();
        CustomType type = new CustomType();
        type.setName(typeName);
        type.setDescription("test type1 Desc");
        type.setTitle("test type1 title");
        type.setParentName("cm:content");
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setDataType("int");
        props = new ArrayList(1);
        props.add(typeProp);
        type.setProperties(props);
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 400);
        typeProp.setDataType("d:int");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 201);
        response = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        this.compareCustomTypesAspects((AbstractCustomClass)type, (AbstractCustomClass)returnedType, "prefixedName", "indexTokenisationMode");
        Assert.assertEquals((String)"Shouldn't list the inherited properties from 'cm:content'.", (long)1L, (long)returnedType.getProperties().size());
        customModelProperty = (CustomModelProperty)returnedType.getProperties().get(0);
        Assert.assertEquals((Object)typePropName, (Object)customModelProperty.getName());
        Assert.assertEquals((Object)"d:int", (Object)customModelProperty.getDataType());
        Assert.assertEquals((Object)((String)namespacePair.getSecond() + ":" + typePropName), (Object)customModelProperty.getPrefixedName());
        Assert.assertTrue((boolean)customModelProperty.isIndexed());
        Assert.assertEquals((Object)Facetable.UNSET, (Object)customModelProperty.getFacetable());
        Assert.assertEquals((Object)IndexTokenisationMode.TRUE, (Object)customModelProperty.getIndexTokenisationMode());
        String typeName2 = "testType2" + System.currentTimeMillis();
        CustomType type2 = new CustomType();
        type2.setName(typeName2);
        type2.setDescription("test type2 Desc");
        type2.setTitle("test type2 title");
        type2.setParentName("cm:content");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type2), 201);
        String typeName3 = "testType3" + System.currentTimeMillis();
        CustomType type3 = new CustomType();
        type3.setName(typeName3);
        type3.setDescription("test type3 Desc");
        type3.setTitle("test type3 title");
        type3.setParentName("cm:content");
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type3), 201);
        HttpResponse response2 = this.getSingle("cmm", modelName, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomModel.class);
        Assert.assertNull((Object)returnedModel.getTypes());
        Assert.assertNull((Object)returnedModel.getAspects());
        response2 = this.getSingle("cmm", modelName + "?select=all", 200);
        returnedModel = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomModel.class);
        Assert.assertNotNull((Object)returnedModel.getTypes());
        Assert.assertEquals((long)3L, (long)returnedModel.getTypes().size());
        Assert.assertNotNull((Object)returnedModel.getAspects());
        Assert.assertEquals((long)1L, (long)returnedModel.getAspects().size());
    }

    @Test
    public void testCustomModelTypesAspectsDependencies() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelNameOne = "testModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameOne, namespacePair, CustomModel.ModelStatus.DRAFT, null, "Mark Moe");
        String typeBaseName = "testTypeBase" + System.currentTimeMillis();
        String typeBaseNameWithPrefix = (String)namespacePair.getSecond() + ":" + typeBaseName;
        this.createTypeAspect(CustomType.class, modelNameOne, typeBaseName, "test typeBase title", "test typeBase Desc", "cm:content");
        CustomModel modelOneStatusPayload = new CustomModel();
        modelOneStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 200);
        HttpResponse response = this.getSingle("cmm", modelNameOne, 200);
        CustomModel returnedModel = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModel.class);
        Assert.assertEquals((Object)CustomModel.ModelStatus.ACTIVE, (Object)returnedModel.getStatus());
        String typeName2 = "testTypeChild" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelNameOne, typeName2, "test typeChild title", "test typeChild Desc", typeBaseNameWithPrefix);
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        response = this.getAll("cmm/" + modelNameOne + "/types", paging, 200);
        List<CustomType> returnedTypes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), CustomType.class);
        Assert.assertEquals((long)2L, (long)returnedTypes.size());
        String modelNameTwo = "testModelTwo" + System.currentTimeMillis();
        Pair<String, String> modelTwoNamespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelNameTwo, modelTwoNamespacePair, CustomModel.ModelStatus.DRAFT, null, "Admin");
        String modelTwoTypeName = "testModelTwoChild" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelNameTwo, modelTwoTypeName, "test model two type child title", null, typeBaseNameWithPrefix);
        modelOneStatusPayload = new CustomModel();
        modelOneStatusPayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 409);
        CustomModel modelTwoStatusPayload = new CustomModel();
        modelTwoStatusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(modelTwoStatusPayload), "?select=status", 200);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 409);
        modelTwoStatusPayload = new CustomModel();
        modelTwoStatusPayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelNameTwo, RestApiUtil.toJsonAsString(modelTwoStatusPayload), "?select=status", 200);
        this.delete("cmm/" + modelNameTwo + "/types", modelTwoTypeName, 204);
        this.put("cmm", modelNameOne, RestApiUtil.toJsonAsString(modelOneStatusPayload), "?select=status", 200);
    }

    @Test
    public void testDeleteTypeAspect() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testDeleteTypeModel" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT, null, "Joe Bloggs");
        String typeName = "testType" + System.currentTimeMillis();
        String typeNameWithPrefix = (String)namespacePair.getSecond() + ":" + typeName;
        CustomType type = this.createTypeAspect(CustomType.class, modelName, typeName, "test type title", "test type Desc", "cm:content");
        String aspectName = "testAspect" + System.currentTimeMillis();
        String aspectNameWithPrefix = (String)namespacePair.getSecond() + ":" + aspectName;
        CustomAspect aspect = this.createTypeAspect(CustomAspect.class, modelName, aspectName, null, null, null);
        this.setRequestContext(this.nonAdminUserName);
        this.delete("cmm/" + modelName + "/types", typeName, 403);
        this.setRequestContext(this.customModelAdmin);
        this.delete("cmm/" + modelName + "/types", typeName, 204);
        this.getSingle("cmm/" + modelName + "/types", typeName, 404);
        this.setRequestContext(this.nonAdminUserName);
        this.delete("cmm/" + modelName + "/aspects", aspectName, 403);
        this.setRequestContext(this.customModelAdmin);
        this.delete("cmm/" + modelName + "/aspects", aspectName, 204);
        this.getSingle("cmm/" + modelName + "/aspects", aspectName, 404);
        this.setRequestContext(this.customModelAdmin);
        this.post("cmm/" + modelName + "/types", RestApiUtil.toJsonAsString(type), 201);
        HttpResponse response = this.getSingle("cmm/" + modelName + "/types", type.getName(), 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomType.class);
        this.compareCustomTypesAspects((AbstractCustomClass)type, (AbstractCustomClass)returnedType, "prefixedName");
        this.post("cmm/" + modelName + "/aspects", RestApiUtil.toJsonAsString(aspect), 201);
        response = this.getSingle("cmm/" + modelName + "/aspects", aspect.getName(), 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        this.compareCustomTypesAspects((AbstractCustomClass)aspect, (AbstractCustomClass)returnedAspect, "prefixedName");
        CustomType payload = new CustomType();
        payload.setName(typeName);
        String typePropName = "testType1Prop1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property title");
        typeProp.setDataType("d:int");
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(typeProp);
        payload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(payload), "?select=props", 200);
        CustomModel statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        String childTypeName = "testChildType" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, childTypeName, "test child type title", null, typeNameWithPrefix);
        String childAspectName = "testChildAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, childAspectName, "test child aspect title", null, aspectNameWithPrefix);
        this.delete("cmm/" + modelName + "/types", typeName, 409);
        this.delete("cmm/" + modelName + "/aspects", childAspectName, 409);
        statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        this.delete("cmm/" + modelName + "/types", typeName, 409);
        this.delete("cmm/" + modelName + "/types", childTypeName, 204);
        this.getSingle("cmm/" + modelName + "/types", childTypeName, 404);
        this.delete("cmm/" + modelName + "/types", typeName, 204);
        this.getSingle("cmm/" + modelName + "/types", typeName, 404);
        this.delete("cmm/" + modelName + "/aspects", aspectName, 409);
        this.delete("cmm/" + modelName + "/aspects", childAspectName, 204);
        this.getSingle("cmm/" + modelName + "/aspects", childAspectName, 404);
        this.delete("cmm/" + modelName + "/aspects", aspectName, 204);
        this.getSingle("cmm/" + modelName + "/aspects", aspectName, 404);
    }

    @Test
    public void testUpdateAspectsTypes() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModeEditAspectType" + System.currentTimeMillis();
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT);
        String aspectName = "testAspect" + System.currentTimeMillis();
        this.createTypeAspect(CustomAspect.class, modelName, aspectName, "title", "desc", null);
        CustomAspect aspectPayload = new CustomAspect();
        aspectPayload.setDescription(null);
        aspectPayload.setTitle("title modified");
        aspectPayload.setParentName("cm:titled");
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 403);
        this.setRequestContext(this.customModelAdmin);
        aspectPayload.setName(aspectName + "Modified");
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 404);
        aspectPayload.setName(aspectName);
        HttpResponse response = this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 200);
        CustomAspect returnedAspect = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomAspect.class);
        this.compareCustomTypesAspects((AbstractCustomClass)aspectPayload, (AbstractCustomClass)returnedAspect, "prefixedName");
        aspectPayload.setParentName("cm:titled" + System.currentTimeMillis());
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 409);
        CustomModel statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        aspectPayload.setParentName(null);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 409);
        statusPayload = new CustomModel();
        statusPayload.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload), "?select=status", 200);
        this.put("cmm/" + modelName + "/aspects", aspectName, RestApiUtil.toJsonAsString(aspectPayload), null, 200);
        String typeName = "testType" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeName, "title", "desc", "cm:content");
        CustomType addPropertyPayload = new CustomType();
        addPropertyPayload.setName(typeName);
        String typePropName = "testTypeProp1" + System.currentTimeMillis();
        CustomModelProperty typeProp = new CustomModelProperty();
        typeProp.setName(typePropName);
        typeProp.setTitle("property title");
        typeProp.setDataType("d:text");
        ArrayList<CustomModelProperty> props = new ArrayList<CustomModelProperty>(1);
        props.add(typeProp);
        addPropertyPayload.setProperties(props);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(addPropertyPayload), "?select=props", 200);
        CustomType typePayload = new CustomType();
        typePayload.setDescription("desc modified");
        typePayload.setTitle("title modified");
        this.setRequestContext(this.nonAdminUserName);
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 403);
        this.setRequestContext(this.customModelAdmin);
        typePayload.setName(typeName + "Modified");
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 404);
        typePayload.setName(typeName);
        HttpResponse response2 = this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 200);
        CustomType returnedType = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomType.class);
        Assert.assertEquals((Object)typePayload.getDescription(), (Object)returnedType.getDescription());
        Assert.assertEquals((Object)typePayload.getTitle(), (Object)returnedType.getTitle());
        Assert.assertNotNull((Object)returnedType.getProperties());
        Assert.assertEquals((long)1L, (long)returnedType.getProperties().size());
        Assert.assertEquals((Object)typePropName, (Object)((CustomModelProperty)returnedType.getProperties().iterator().next()).getName());
        typePayload.setParentName("cm:folder" + System.currentTimeMillis());
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 409);
        CustomModel statusPayload2 = new CustomModel();
        statusPayload2.setStatus(CustomModel.ModelStatus.ACTIVE);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload2), "?select=status", 200);
        typePayload.setParentName("cm:folder");
        this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 409);
        statusPayload2 = new CustomModel();
        statusPayload2.setStatus(CustomModel.ModelStatus.DRAFT);
        this.put("cmm", modelName, RestApiUtil.toJsonAsString(statusPayload2), "?select=status", 200);
        response2 = this.put("cmm/" + modelName + "/types", typeName, RestApiUtil.toJsonAsString(typePayload), null, 200);
        returnedType = RestApiUtil.parseRestApiEntry(response2.getJsonResponse(), CustomType.class);
        Assert.assertEquals((Object)typePayload.getParentName(), (Object)returnedType.getParentName());
    }
}

