/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.archive.ArchivedNodesCannedQueryBuilder;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.rest.api.DeletedNodes;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.NodeTargetAssoc;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;

public class DeletedNodesImpl
implements DeletedNodes,
RecognizedParamsExtractor {
    private NodeArchiveService nodeArchiveService;
    private PersonService personService;
    private NodeService nodeService;
    private Nodes nodes;
    private Renditions renditions;

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setRenditions(Renditions renditions) {
        this.renditions = renditions;
    }

    private void mapArchiveInfo(Node aNode, Map<String, UserInfo> mapUserInfo) {
        if (mapUserInfo == null) {
            mapUserInfo = new HashMap<String, UserInfo>();
        }
        Map nodeProps = this.nodeService.getProperties(aNode.getNodeRef());
        aNode.setArchivedAt((Date)nodeProps.get(ContentModel.PROP_ARCHIVED_DATE));
        aNode.setArchivedByUser(Node.lookupUserInfo((String)nodeProps.get(ContentModel.PROP_ARCHIVED_BY), mapUserInfo, this.personService));
        aNode.setParentId(null);
    }

    @Override
    public CollectionWithPagingInfo<Node> listDeleted(Parameters parameters) {
        PagingRequest pagingRequest = Util.getPagingRequest(parameters.getPaging());
        NodeRef archiveStoreRootNodeRef = this.nodeService.getStoreArchiveNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ArchivedNodesCannedQueryBuilder queryBuilder = new ArchivedNodesCannedQueryBuilder.Builder(archiveStoreRootNodeRef, pagingRequest).sortOrderAscending(false).build();
        PagingResults result = this.nodeArchiveService.listArchivedNodes(queryBuilder);
        Integer totalItems = (Integer)result.getTotalResultCount().getFirst();
        ArrayList<Node> nodesFound = new ArrayList<Node>(result.getPage().size());
        HashMap<String, UserInfo> mapUserInfo = new HashMap<String, UserInfo>();
        for (NodeRef nRef : result.getPage()) {
            Node foundNode = this.nodes.getFolderOrDocument(nRef, null, null, parameters.getInclude(), mapUserInfo);
            this.mapArchiveInfo(foundNode, mapUserInfo);
            nodesFound.add(foundNode);
        }
        return CollectionWithPagingInfo.asPaged(parameters.getPaging(), nodesFound, result.hasMoreItems(), totalItems == null ? null : Integer.valueOf(totalItems));
    }

    @Override
    public Node getDeletedNode(String originalId, Parameters parameters, boolean fullnode, Map<String, UserInfo> mapUserInfo) {
        NodeRef validatedNodeRef = this.nodes.validateNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, originalId);
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, validatedNodeRef.getId());
        NodeRef archivedNodeRef = this.nodeArchiveService.getArchivedNode(nodeRef);
        Node foundNode = null;
        foundNode = fullnode ? this.nodes.getFolderOrDocumentFullInfo(archivedNodeRef, null, null, parameters, mapUserInfo) : this.nodes.getFolderOrDocument(archivedNodeRef, null, null, parameters.getInclude(), mapUserInfo);
        if (foundNode != null) {
            this.mapArchiveInfo(foundNode, null);
        }
        return foundNode;
    }

    @Override
    public Node restoreArchivedNode(String archivedId, NodeTargetAssoc nodeTargetAssoc) {
        NodeRef validatedNodeRef = this.nodes.validateNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, archivedId);
        RestoreNodeReport restored = null;
        if (nodeTargetAssoc != null) {
            NodeRef targetNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeTargetAssoc.getTargetParentId());
            QName assocType = this.nodes.getAssocType(nodeTargetAssoc.getAssocType());
            restored = this.nodeArchiveService.restoreArchivedNode(validatedNodeRef, targetNodeRef, assocType, null);
        } else {
            restored = this.nodeArchiveService.restoreArchivedNode(validatedNodeRef);
        }
        switch (restored.getStatus()) {
            case SUCCESS: {
                return this.nodes.getFolderOrDocumentFullInfo(restored.getRestoredNodeRef(), null, null, null, null);
            }
            case FAILURE_PERMISSION: {
                throw new PermissionDeniedException();
            }
            case FAILURE_INTEGRITY: {
                throw new IntegrityException("Restore failed due to an integrity error", null);
            }
            case FAILURE_DUPLICATE_CHILD_NODE_NAME: {
                throw new ConstraintViolatedException("Name already exists in target");
            }
            case FAILURE_INVALID_ARCHIVE_NODE: {
                throw new EntityNotFoundException(archivedId);
            }
            case FAILURE_INVALID_PARENT: {
                throw new NotFoundException("Invalid parent id " + String.valueOf(restored.getTargetParentNodeRef()));
            }
        }
        throw new ApiException("Unable to restore node " + archivedId);
    }

    @Override
    public void purgeArchivedNode(String archivedId) {
        NodeRef validatedNodeRef = this.nodes.validateNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, archivedId);
        this.nodeArchiveService.purgeArchivedNode(validatedNodeRef);
    }

    @Override
    public BinaryResource getContent(String archivedId, String renditionId, Parameters parameters) {
        NodeRef validatedNodeRef = this.nodes.validateNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, archivedId);
        if (renditionId != null) {
            return this.renditions.getContent(validatedNodeRef, renditionId, parameters);
        }
        return this.nodes.getContent(validatedNodeRef, parameters, false);
    }

    @Override
    public Rendition getRendition(String archivedId, String renditionId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, archivedId);
        Rendition rendition = this.renditions.getRendition(nodeRef, renditionId, parameters);
        return rendition;
    }

    @Override
    public CollectionWithPagingInfo<Rendition> getRenditions(String archivedId, Parameters parameters) {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, archivedId);
        return this.renditions.getRenditions(nodeRef, parameters);
    }

    @Override
    public DirectAccessUrl requestContentDirectUrl(String originalNodeId, String renditionId, boolean attachment, Long validFor, String fileName) {
        NodeRef validatedNodeRef = this.nodes.validateNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, originalNodeId);
        if (renditionId != null) {
            return this.renditions.requestContentDirectUrl(validatedNodeRef, null, renditionId, attachment, validFor, fileName);
        }
        return this.nodes.requestContentDirectUrl(validatedNodeRef, attachment, validFor, fileName);
    }
}

