/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.framework.Operation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;

public class ResourceInspectorUtil {
    private static Log logger = LogFactory.getLog(ResourceInspectorUtil.class);

    protected static Class determineType(Class resource, Method method) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        Annotation annot = AnnotationUtils.findAnnotation((Method)resolvedMethod, Operation.class);
        if (annot != null) {
            return ResourceInspectorUtil.determineOperationType(resource, method);
        }
        Class returnType = GenericTypeResolver.resolveReturnType((Method)resolvedMethod, (Class)resource);
        if (List.class.isAssignableFrom(returnType)) {
            return ResolvableType.forMethodReturnType((Method)method).asCollection().getGeneric(new int[]{0}).resolve();
        }
        return returnType;
    }

    protected static Class determineOperationType(Class resource, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null) {
            switch (paramTypes.length) {
                case 4: 
                case 5: {
                    int position = paramTypes.length - 3;
                    if (Void.class.equals(paramTypes[position])) {
                        return null;
                    }
                    return paramTypes[position];
                }
            }
        }
        throw new IllegalArgumentException("Your method signature should have 4 parameters (uniqueId, typePassedin, Parameters, WithResponse), use Void if you are not interested in the second argument. " + resource.getName() + " " + method.getName());
    }

    public static List<Method> findMethodsByAnnotation(Class objClass, Class<? extends Annotation> annotationType) {
        Method[] methods;
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods = objClass.getMethods()) {
            Annotation annot = AnnotationUtils.findAnnotation((Method)method, annotationType);
            if (annot == null) continue;
            Method resolvedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
            annotatedMethods.add(resolvedMethod);
        }
        return annotatedMethods;
    }

    public static Object invokeMethod(Method annotatedMethod, Object obj) {
        try {
            return ResourceInspectorUtil.invokeMethod(annotatedMethod, obj, null);
        }
        catch (Throwable error) {
            logger.error((Object)"Invocation failure", error);
            return null;
        }
    }

    public static Object invokeMethod(Method annotatedMethod, Object obj, Object ... args) throws Throwable {
        if (annotatedMethod != null) {
            try {
                return annotatedMethod.invoke(obj, args);
            }
            catch (IllegalArgumentException error) {
                logger.warn((Object)"Invocation error", (Throwable)error);
            }
            catch (IllegalAccessException error) {
                logger.warn((Object)"IllegalAccessException", (Throwable)error);
            }
            catch (InvocationTargetException error) {
                logger.warn((Object)"InvocationTargetException", (Throwable)error);
                throw error.getCause();
            }
        }
        return null;
    }
}

