/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class TenantWebScriptServletRequest
extends WebScriptServletRequest {
    protected String tenant;
    protected String pathInfo;

    protected void parse() {
        String realPathInfo;
        int idx = (realPathInfo = this.getRealPathInfo()).indexOf(47, 1);
        this.tenant = realPathInfo.substring(1, idx == -1 ? realPathInfo.length() : idx);
        this.pathInfo = realPathInfo.substring(this.tenant.length() + 1);
    }

    public TenantWebScriptServletRequest(Runtime container, HttpServletRequest req, Match serviceMatch, ServerProperties serverProperties) {
        super(container, req, serviceMatch, serverProperties);
        this.parse();
    }

    public String getServiceContextPath() {
        return this.getHttpServletRequest().getContextPath() + this.getHttpServletRequest().getServletPath() + "/" + this.tenant;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getTenant() {
        return this.tenant;
    }

    protected String getRealPathInfo() {
        String requestURI = this.getHttpServletRequest().getRequestURI();
        String serviceContextPath = this.getHttpServletRequest().getContextPath() + this.getHttpServletRequest().getServletPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? this.getHttpServletRequest().getPathInfo() : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length()));
        return pathInfo;
    }
}

