/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.categories;

import java.util.List;
import org.alfresco.rest.api.Categories;
import org.alfresco.rest.api.categories.CategoriesEntityResource;
import org.alfresco.rest.api.model.Category;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.ListPage;
import org.alfresco.rest.framework.resource.parameters.Parameters;

@RelationshipResource(name="subcategories", entityResource=CategoriesEntityResource.class, title="Subcategories")
public class SubcategoriesRelation
implements RelationshipResourceAction.Create<Category>,
RelationshipResourceAction.Read<Category> {
    private final Categories categories;

    public SubcategoriesRelation(Categories categories) {
        this.categories = categories;
    }

    @Override
    @WebApiDescription(title="Create a category", description="Creates one or more categories under a parent category", successStatus=201)
    public List<Category> create(String parentCategoryId, List<Category> categoryList, Parameters parameters) {
        return this.categories.createSubcategories(parentCategoryId, categoryList, parameters);
    }

    @Override
    @WebApiDescription(title="List category direct children", description="Lists direct children of a parent category", successStatus=200)
    public CollectionWithPagingInfo<Category> readAll(String parentCategoryId, Parameters parameters) {
        return ListPage.of(this.categories.getCategoryChildren(parentCategoryId, parameters), parameters.getPaging());
    }
}

