/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class NodeValidatorTest {
    private static final String FOLDER_NODE_ID = "dummy-folder-node-id";
    private static final String LINK_TO_NODE_ID = "dummy-link-to-node-id";
    private static final String RULE_SET_ID = "dummy-rule-set-id";
    private static final String RULE_ID = "dummy-rule-id";
    private static final String PARENT_NODE_ID = "dummy-parent-node-id";
    private static final NodeRef folderNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-folder-node-id");
    private static final NodeRef ruleSetNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-set-id");
    private static final NodeRef ruleNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-rule-id");
    private static final NodeRef parentNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-parent-node-id");
    @Mock
    private Nodes nodesMock;
    @Mock
    private Node ruleSetNodeMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private RuleService ruleServiceMock;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private ChildAssociationRef primaryParentMock;
    @InjectMocks
    private NodeValidator nodeValidator;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(FOLDER_NODE_ID)).willReturn((Object)folderNodeRef);
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_SET_ID)).willReturn((Object)ruleSetNodeRef);
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_ID)).willReturn((Object)ruleNodeRef);
        BDDMockito.given((Object)this.nodesMock.nodeMatches((NodeRef)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any())).willReturn((Object)true);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission((NodeRef)ArgumentMatchers.any())).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).willReturn((Object)AccessStatus.ALLOWED);
    }

    @Test
    public void testValidateFolderNode() {
        NodeRef nodeRef = this.nodeValidator.validateFolderNode(FOLDER_NODE_ID, false);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(FOLDER_NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(folderNodeRef, Set.of(ContentModel.TYPE_FOLDER), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(folderNodeRef);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)folderNodeRef);
    }

    @Test
    public void testValidateFolderNode_notExistingFolder() {
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(FOLDER_NODE_ID)).willThrow(new Throwable[]{new EntityNotFoundException(FOLDER_NODE_ID)});
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.nodeValidator.validateFolderNode(FOLDER_NODE_ID, false));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(FOLDER_NODE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateFolderNode_notMatchingTypeFolder() {
        BDDMockito.given((Object)this.nodesMock.nodeMatches((NodeRef)ArgumentMatchers.any(), (Set)ArgumentMatchers.eq(Set.of(ContentModel.TYPE_FOLDER)), (Set)ArgumentMatchers.any())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.nodeValidator.validateFolderNode(FOLDER_NODE_ID, false));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateOrLookupNode(FOLDER_NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(folderNodeRef, Set.of(ContentModel.TYPE_FOLDER), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateFolderNode_noReadPermission() {
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission((NodeRef)ArgumentMatchers.any())).willReturn((Object)AccessStatus.DENIED);
        Assertions.assertThatExceptionOfType(PermissionDeniedException.class).isThrownBy(() -> this.nodeValidator.validateFolderNode(FOLDER_NODE_ID, false));
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(folderNodeRef);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateFolderNode_noChangePermission() {
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission((NodeRef)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).willReturn((Object)AccessStatus.DENIED);
        Assertions.assertThatExceptionOfType(PermissionDeniedException.class).isThrownBy(() -> this.nodeValidator.validateFolderNode(folderNodeRef.getId(), true));
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(folderNodeRef, "ChangePermissions");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void validateRuleSetNode() {
        BDDMockito.given((Object)this.ruleServiceMock.isRuleSetAssociatedWithFolder((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)true);
        NodeRef nodeRef = this.nodeValidator.validateRuleSetNode(RULE_SET_ID, folderNodeRef);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_SET_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(ruleSetNodeRef, Set.of(ContentModel.TYPE_SYSTEM_FOLDER), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleSetAssociatedWithFolder(ruleSetNodeRef, folderNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)ruleSetNodeRef);
    }

    @Test
    public void testValidateRuleSetNodeNoParentId() {
        BDDMockito.given((Object)this.nodesMock.getNode((String)ArgumentMatchers.any())).willReturn((Object)this.ruleSetNodeMock);
        BDDMockito.given((Object)this.nodeServiceMock.getPrimaryParent((NodeRef)ArgumentMatchers.any())).willReturn((Object)this.primaryParentMock);
        BDDMockito.given((Object)this.primaryParentMock.getParentRef()).willReturn((Object)parentNodeRef);
        NodeRef nodeRef = this.nodeValidator.validateRuleSetNode(LINK_TO_NODE_ID, true);
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)parentNodeRef);
    }

    @Test
    public void validateRuleSetNode_defaultId() {
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode((NodeRef)ArgumentMatchers.any())).willReturn((Object)ruleSetNodeRef);
        NodeRef nodeRef = this.nodeValidator.validateRuleSetNode("-default-", folderNodeRef);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(folderNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)ruleSetNodeRef);
    }

    @Test
    public void testValidateRuleSetNode_notExistingRuleSet() {
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_SET_ID)).willThrow(new Throwable[]{new EntityNotFoundException(RULE_SET_ID)});
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.nodeValidator.validateRuleSetNode(RULE_SET_ID, folderNodeRef));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_SET_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateRuleSetNode_notMatchingTypeSystemFolder() {
        BDDMockito.given((Object)this.nodesMock.nodeMatches((NodeRef)ArgumentMatchers.any(), (Set)ArgumentMatchers.eq(Set.of(ContentModel.TYPE_SYSTEM_FOLDER)), (Set)ArgumentMatchers.any())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.nodeValidator.validateRuleSetNode(RULE_SET_ID, folderNodeRef));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_SET_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(ruleSetNodeRef, Set.of(ContentModel.TYPE_SYSTEM_FOLDER), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateRuleSetNode_notExistingDefaultRuleSet() {
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(folderNodeRef)).willReturn(null);
        Assertions.assertThatExceptionOfType(RelationshipResourceNotFoundException.class).isThrownBy(() -> this.nodeValidator.validateRuleSetNode("-default-", folderNodeRef));
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(folderNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateRuleSetNode_notAssociatedRuleSetToFolder() {
        BDDMockito.given((Object)this.ruleServiceMock.isRuleSetAssociatedWithFolder((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.nodeValidator.validateRuleSetNode(RULE_SET_ID, folderNodeRef));
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleSetAssociatedWithFolder(ruleSetNodeRef, folderNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void validateRuleNode() {
        BDDMockito.given((Object)this.ruleServiceMock.isRuleAssociatedWithRuleSet((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)true);
        NodeRef nodeRef = this.nodeValidator.validateRuleNode(RULE_ID, ruleSetNodeRef);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(ruleNodeRef, Set.of(RuleModel.TYPE_RULE), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleAssociatedWithRuleSet(ruleNodeRef, ruleSetNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)ruleNodeRef);
    }

    @Test
    public void validateRuleNode_nullRuleSet() {
        NodeRef nodeRef = this.nodeValidator.validateRuleNode(RULE_ID, null);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(ruleNodeRef, Set.of(RuleModel.TYPE_RULE), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
        ((ObjectAssert)Assertions.assertThat((Object)nodeRef).isNotNull()).isEqualTo((Object)ruleNodeRef);
    }

    @Test
    public void testValidateRuleNode_notExistingRule() {
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_ID)).willThrow(new Throwable[]{new EntityNotFoundException(RULE_ID)});
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.nodeValidator.validateRuleNode(RULE_ID, ruleSetNodeRef));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateRuleNode_notMatchingTypeRule() {
        BDDMockito.given((Object)this.nodesMock.nodeMatches((NodeRef)ArgumentMatchers.any(), (Set)ArgumentMatchers.eq(Set.of(RuleModel.TYPE_RULE)), (Set)ArgumentMatchers.any())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.nodeValidator.validateRuleNode(RULE_ID, ruleSetNodeRef));
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(RULE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(ruleNodeRef, Set.of(RuleModel.TYPE_RULE), null);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testValidateRuleNode_notAssociatedRuleToRuleSet() {
        BDDMockito.given((Object)this.ruleServiceMock.isRuleAssociatedWithRuleSet((NodeRef)ArgumentMatchers.any(), (NodeRef)ArgumentMatchers.any())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.nodeValidator.validateRuleNode(RULE_ID, ruleSetNodeRef));
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleAssociatedWithRuleSet(ruleNodeRef, ruleSetNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testIsRuleSetNode() {
        this.resetNodesMock();
        boolean actual = this.nodeValidator.isRuleSetNode(RULE_SET_ID);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsNotRuleSetNode() {
        this.resetNodesMock();
        boolean actual = this.nodeValidator.isRuleSetNode(FOLDER_NODE_ID);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsRuleSetNotNullAndShared() {
        BDDMockito.given((Object)this.ruleServiceMock.isRuleSetShared((NodeRef)ArgumentMatchers.any())).willReturn((Object)true);
        boolean shared = this.nodeValidator.isRuleSetNotNullAndShared(ruleSetNodeRef);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleSetShared(ruleSetNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((boolean)shared).isTrue();
    }

    @Test
    public void testIsRuleSetNotNullAndShared_nullRuleSetNode() {
        boolean shared = this.nodeValidator.isRuleSetNotNullAndShared(null);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoInteractions();
        Assertions.assertThat((boolean)shared).isFalse();
    }

    @Test
    public void testIsRuleSetNotNullAndShared_withoutRuleSetAndWithFolder() {
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode((NodeRef)ArgumentMatchers.any())).willReturn((Object)ruleSetNodeRef);
        this.nodeValidator.isRuleSetNotNullAndShared(null, folderNodeRef);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(folderNodeRef);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleSetShared(ruleSetNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testIsRuleSetNotNullAndShared_withRuleSetAndWithFolder() {
        this.nodeValidator.isRuleSetNotNullAndShared(ruleSetNodeRef, folderNodeRef);
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).isRuleSetShared(ruleSetNodeRef);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
    }

    private void resetNodesMock() {
        Mockito.reset((Object[])new Nodes[]{this.nodesMock});
        BDDMockito.given((Object)this.nodesMock.validateOrLookupNode(FOLDER_NODE_ID)).willReturn((Object)folderNodeRef);
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_SET_ID)).willReturn((Object)ruleSetNodeRef);
        BDDMockito.given((Object)this.nodesMock.validateNode(RULE_ID)).willReturn((Object)ruleNodeRef);
        BDDMockito.given((Object)this.nodesMock.nodeMatches(ruleSetNodeRef, Set.of(ContentModel.TYPE_SYSTEM_FOLDER), null)).willReturn((Object)true);
    }
}

