/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={LuceneTests.class})
public class BlogServiceTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(BlogServiceTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private NodeArchiveService nodeArchiveService;
    private ActivityService activityService;
    private FeedGenerator feedGenerator;
    private PostLookup postLookup;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String SITE_SHORT_NAME_BLOG = "BlogSiteShortNameTest";
    private static final String COMPONENT_BLOG = "blog";
    private static final String URL_BLOG_POST = "/api/blog/post/site/BlogSiteShortNameTest/blog/";
    private static final String URL_BLOG_CORE = "/api/blog/site/BlogSiteShortNameTest/blog";
    private static final String URL_BLOG_POSTS = "/api/blog/site/BlogSiteShortNameTest/blog/posts";
    private static final String URL_MY_DRAFT_BLOG_POSTS = "/api/blog/site/BlogSiteShortNameTest/blog/posts/mydrafts";
    private static final String URL_MY_PUBLISHED_BLOG_POSTS = "/api/blog/site/BlogSiteShortNameTest/blog/posts/mypublished";
    private static final String URL_DELETE_COMMENT = "api/comment/node/{0}/{1}/{2}?site={3}&itemtitle={4}&page={5}";
    private List<String> posts;
    private List<String> drafts;

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.activityService = (ActivityService)this.getServer().getApplicationContext().getBean("activityService");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.getServer().getApplicationContext().getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_BLOG);
        if (siteInfo == null) {
            this.siteService.createSite("BlogSitePreset", SITE_SHORT_NAME_BLOG, "BlogSiteTitle", "BlogSiteDescription", SiteVisibility.PUBLIC);
        }
        this.createUser(USER_ONE, "SiteCollaborator", SITE_SHORT_NAME_BLOG);
        this.createUser(USER_TWO, "SiteCollaborator", SITE_SHORT_NAME_BLOG);
        this.posts = new ArrayList<String>(5);
        this.drafts = new ArrayList<String>(5);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_BLOG);
        if (siteInfo != null) {
            this.siteService.deleteSite(SITE_SHORT_NAME_BLOG);
            this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        }
        this.personService.deletePerson(USER_ONE);
        if (this.authenticationService.authenticationExists(USER_ONE)) {
            this.authenticationService.deleteAuthentication(USER_ONE);
        }
        this.personService.deletePerson(USER_TWO);
        if (this.authenticationService.authenticationExists(USER_TWO)) {
            this.authenticationService.deleteAuthentication(USER_TWO);
        }
    }

    private void createUser(String userName, String role, String siteMembership) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(siteMembership, userName, role);
    }

    private JSONObject getRequestObject(String title, String content, String[] tags, boolean isDraft) throws Exception {
        JSONObject post = new JSONObject();
        if (title != null) {
            post.put("title", (Object)title);
        }
        if (content != null) {
            post.put("content", (Object)content);
        }
        if (tags != null) {
            JSONArray arr = new JSONArray();
            for (String s : tags) {
                arr.put((Object)s);
            }
            post.put("tags", (Object)arr);
        }
        post.put("draft", isDraft);
        return post;
    }

    private JSONObject createPost(String title, String content, String[] tags, boolean isDraft, int expectedStatus) throws Exception {
        JSONObject post = this.getRequestObject(title, content, tags, isDraft);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_BLOG_POSTS, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject item = result.getJSONObject("item");
        if (isDraft) {
            this.drafts.add(item.getString("name"));
        } else {
            this.posts.add(item.getString("name"));
        }
        return item;
    }

    private JSONObject updatePost(String name, String title, String content, String[] tags, boolean isDraft, int expectedStatus) throws Exception {
        JSONObject post = this.getRequestObject(title, content, tags, isDraft);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_BLOG_POST + name, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject getPost(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_POST + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result.getJSONObject("item");
        }
        return null;
    }

    private String getCommentsUrl(String nodeRef) {
        return "/api/node/" + nodeRef.replace("://", "/") + "/comments";
    }

    private String getCommentUrl(String nodeRef) {
        return "/api/comment/node/" + nodeRef.replace("://", "/");
    }

    private String getDeleteCommentUrl(NodeRef commentNodeRef) {
        String itemTitle = "Test Title";
        String page = "document-details";
        String URL2 = MessageFormat.format(URL_DELETE_COMMENT, commentNodeRef.getStoreRef().getProtocol(), commentNodeRef.getStoreRef().getIdentifier(), commentNodeRef.getId(), SITE_SHORT_NAME_BLOG, itemTitle, page);
        return URL2;
    }

    private JSONObject createComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        comment.put("site", (Object)SITE_SHORT_NAME_BLOG);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getCommentsUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject updateComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getCommentUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    public void testCreateDraftPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createPost(title, content, null, true, 200);
        BlogServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)true, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 404);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_MY_DRAFT_BLOG_POSTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertTrue((String)"Wrong number of posts", (result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testCreateDraftPostWithTagsAndComment() throws Exception {
        String[] tags = new String[]{"foo", "bar"};
        String title = "test";
        String content = "test";
        JSONObject item = this.createPost(title, content, tags, true, 200);
        BlogServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)true, (Object)item.get("isDraft"));
        JSONArray reportedTags = (JSONArray)item.get("tags");
        BlogServiceTest.assertEquals((String)"Tags size was wrong.", (int)2, (int)reportedTags.length());
        List<String> recoveredTagsList = Arrays.asList(reportedTags.getString(0), reportedTags.getString(1));
        BlogServiceTest.assertEquals((String)"Tags were wrong.", Arrays.asList(tags), recoveredTagsList);
        NodeRef blogPostNode = new NodeRef(item.getString("nodeRef"));
        String commentsPostUrl = "/api/node/" + blogPostNode.getStoreRef().getProtocol() + "/" + blogPostNode.getStoreRef().getIdentifier() + "/" + blogPostNode.getId() + "/comments";
        String jsonToPost = new JSONStringer().object().key("title").value((Object)"Commented blog title").key("content").value((Object)"Some content.").endObject().toString();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(commentsPostUrl, jsonToPost, "application/json"), 200);
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 404);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_MY_DRAFT_BLOG_POSTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONArray items = result.getJSONArray("items");
        JSONArray tagsArray = items.getJSONObject(0).getJSONArray("tags");
        BlogServiceTest.assertEquals((String)"Wrong number of tags", (int)2, (int)tagsArray.length());
        BlogServiceTest.assertEquals((String)"Tag wrong", (String)tags[0], (String)tagsArray.getString(0));
        BlogServiceTest.assertEquals((String)"Tag wrong", (String)tags[1], (String)tagsArray.getString(1));
        BlogServiceTest.assertEquals((String)"Wrong comment count", (int)1, (int)items.getJSONObject(0).getInt("commentCount"));
        String commentsUrl = "/api" + items.getJSONObject(0).getString("commentsUrl");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(commentsUrl), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/blog/site/BlogSiteShortNameTest/blog/posts?tag=NOSUCHTAG"), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/blog/site/BlogSiteShortNameTest/blog/posts?tag=foo"), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)1, (int)result.getInt("total"));
    }

    public void testCreatePublishedPost() throws Exception {
        String title = "published";
        String content = "content";
        JSONObject item = this.createPost(title, content, null, false, 200);
        String postName = item.getString("name");
        BlogServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)false, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_MY_PUBLISHED_BLOG_POSTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)(this.posts.size() + this.drafts.size()), (int)result.getInt("total"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_BLOG_POST + postName), 200);
    }

    public void testCreateEmptyPost() throws Exception {
        JSONObject item = this.createPost(null, null, null, false, 200);
        BlogServiceTest.assertEquals((Object)"", (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)"", (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)false, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testUpdated() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        item = this.updatePost(name, "new title", "new content", null, false, 200);
        BlogServiceTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
        BlogServiceTest.assertEquals((String)"new title", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)item.getString("content"));
    }

    public void testUpdateWithEmptyValues() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        item = this.updatePost(item.getString("name"), null, null, null, false, 200);
        BlogServiceTest.assertEquals((String)"", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("content"));
    }

    public void testPublishThroughUpdate() throws Exception {
        JSONObject item = this.createPost("test", "test", null, true, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)true, (boolean)item.getBoolean("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(name, 404);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        item = this.updatePost(name, "new title", "new content", null, false, 200);
        BlogServiceTest.assertEquals((String)"new title", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)item.getString("content"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(name, 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testCannotDoUnpublish() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isDraft"));
        item = this.updatePost(name, "new title", "new content", null, true, 400);
    }

    public void testGetAll() throws Exception {
        String url = URL_BLOG_POSTS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)this.posts.size());
        BlogServiceTest.assertEquals((int)0, (int)this.drafts.size());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)0, (int)result.getJSONArray("items").length());
        JSONObject metadata = result.getJSONObject("metadata");
        JSONObject perms = metadata.getJSONObject("blogPermissions");
        BlogServiceTest.assertEquals((boolean)false, (boolean)metadata.getBoolean("externalBlogConfig"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("create"));
        String TITLE_1 = "Published";
        String TITLE_2 = "Draft";
        String TITLE_3 = "Another Published";
        this.createPost(TITLE_1, "Stuff", null, false, 200);
        this.createPost(TITLE_2, "Draft Stuff", null, true, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        metadata = result.getJSONObject("metadata");
        perms = metadata.getJSONObject("blogPermissions");
        BlogServiceTest.assertEquals((boolean)false, (boolean)metadata.getBoolean("externalBlogConfig"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("create"));
        JSONObject blog = result.getJSONArray("items").getJSONObject(0);
        BlogServiceTest.assertEquals((Object)TITLE_1, (Object)blog.get("title"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)blog.getBoolean("isDraft"));
        perms = blog.getJSONObject("permissions");
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        blog = result.getJSONArray("items").getJSONObject(1);
        BlogServiceTest.assertEquals((Object)TITLE_2, (Object)blog.get("title"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)blog.getBoolean("isDraft"));
        perms = blog.getJSONObject("permissions");
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        this.createPost(TITLE_3, "Still Stuff", null, false, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)3, (int)result.getJSONArray("items").length());
        blog = result.getJSONArray("items").getJSONObject(0);
        BlogServiceTest.assertEquals((Object)TITLE_3, (Object)blog.get("title"));
        blog = result.getJSONArray("items").getJSONObject(1);
        BlogServiceTest.assertEquals((Object)TITLE_1, (Object)blog.get("title"));
        blog = result.getJSONArray("items").getJSONObject(2);
        BlogServiceTest.assertEquals((Object)TITLE_2, (Object)blog.get("title"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url + "?pageSize=2&startIndex=0"), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        BlogServiceTest.assertEquals((Object)TITLE_3, (Object)result.getJSONArray("items").getJSONObject(0).get("title"));
        BlogServiceTest.assertEquals((Object)TITLE_1, (Object)result.getJSONArray("items").getJSONObject(1).get("title"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url + "?pageSize=2&startIndex=1"), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)1, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        BlogServiceTest.assertEquals((Object)TITLE_1, (Object)result.getJSONArray("items").getJSONObject(0).get("title"));
        BlogServiceTest.assertEquals((Object)TITLE_2, (Object)result.getJSONArray("items").getJSONObject(1).get("title"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url + "?pageSize=2&startIndex=2"), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)1, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)1, (int)result.getJSONArray("items").length());
        BlogServiceTest.assertEquals((Object)TITLE_2, (Object)result.getJSONArray("items").getJSONObject(0).get("title"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("startIndex"));
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("itemCount"));
        BlogServiceTest.assertEquals((int)2, (int)result.getJSONArray("items").length());
        blog = result.getJSONArray("items").getJSONObject(0);
        BlogServiceTest.assertEquals((Object)TITLE_3, (Object)blog.get("title"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)blog.getBoolean("isDraft"));
        perms = blog.getJSONObject("permissions");
        BlogServiceTest.assertEquals((boolean)false, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
        blog = result.getJSONArray("items").getJSONObject(1);
        BlogServiceTest.assertEquals((Object)TITLE_1, (Object)blog.get("title"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)blog.getBoolean("isDraft"));
        perms = blog.getJSONObject("permissions");
        BlogServiceTest.assertEquals((boolean)false, (boolean)perms.getBoolean("delete"));
        BlogServiceTest.assertEquals((boolean)true, (boolean)perms.getBoolean("edit"));
    }

    public void testGetNew() throws Exception {
        String url = "/api/blog/site/BlogSiteShortNameTest/blog/posts/new";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.posts.size(), (int)result.getInt("total"));
    }

    public void testGetDrafts() throws Exception {
        String url = URL_MY_DRAFT_BLOG_POSTS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_POSTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.drafts.size(), (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testMyPublished() throws Exception {
        String url = URL_MY_PUBLISHED_BLOG_POSTS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.drafts.size(), (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testComments() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        String nodeRef = item.getString("nodeRef");
        JSONObject commentOne = this.createComment(nodeRef, "comment", "content", 200);
        JSONObject commentTwo = this.createComment(nodeRef, "comment", "content", 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        JSONObject commentThree = this.createComment(nodeRef, "comment", "content", 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getCommentUrl(commentThree.getString("nodeRef"))), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        JSONObject commentTwoUpdated = this.updateComment(commentTwo.getString("nodeRef"), "new title", "new content", 200);
        BlogServiceTest.assertEquals((String)"new title", (String)commentTwoUpdated.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)commentTwoUpdated.getString("content"));
    }

    public void testDeleteCommentPostActivity() throws Exception {
        this.authenticationComponent.setCurrentUser(USER_ONE);
        JSONObject item = this.createPost("testActivity", "test", null, false, 200);
        BlogServiceTest.assertNotNull((Object)item);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumStart = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_BLOG).size();
        String nodeRef = item.getString("nodeRef");
        JSONObject commentOne = this.createComment(nodeRef, "comment", "content", 200);
        BlogServiceTest.assertNotNull((Object)item);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_BLOG).size();
        BlogServiceTest.assertEquals((String)"The activity feeds were not generated after adding a comment", (int)(activityNumStart + 1), (int)activityNumNext);
        activityNumStart = activityNumNext;
        NodeRef commentNodeRef = new NodeRef(commentOne.getString("nodeRef"));
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getDeleteCommentUrl(commentNodeRef)), 200);
        BlogServiceTest.assertTrue((resp.getStatus() == 200 ? 1 : 0) != 0);
        this.postLookup.execute();
        this.feedGenerator.execute();
        activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME_BLOG).size();
        BlogServiceTest.assertEquals((String)"The activity feeds were not generated after deleting a comment", (int)(activityNumStart + 1), (int)activityNumNext);
    }

    public void testBlogIntegration() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_CORE), 200);
        String json = response.getContentAsString();
        JSONObject result = new JSONObject(json);
        BlogServiceTest.assertEquals((String)("No item in:\n" + json), (boolean)true, (boolean)result.has("item"));
        JSONObject item = result.getJSONObject("item");
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("qnamePath"));
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("detailsUrl"));
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("blogPostsUrl"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("type"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("name"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("description"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("url"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("username"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("password"));
        JSONObject blog = new JSONObject();
        blog.put("blogType", (Object)"wordpress");
        blog.put("blogName", (Object)"A Blog!");
        blog.put("username", (Object)"guest");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_BLOG_CORE, blog.toString(), "application/json"), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_CORE), 200);
        json = response.getContentAsString();
        result = new JSONObject(json);
        BlogServiceTest.assertEquals((String)("No item in:\n" + json), (boolean)true, (boolean)result.has("item"));
        item = result.getJSONObject("item");
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("qnamePath"));
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("detailsUrl"));
        BlogServiceTest.assertEquals((String)("Missing key in: " + String.valueOf(item)), (boolean)true, (boolean)item.has("blogPostsUrl"));
        BlogServiceTest.assertEquals((String)"wordpress", (String)item.getString("type"));
        BlogServiceTest.assertEquals((String)"A Blog!", (String)item.getString("name"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("description"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("url"));
        BlogServiceTest.assertEquals((String)"guest", (String)item.getString("username"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("password"));
    }

    public void _testTagsStressTest() throws Exception {
        final List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<Thread> threads = new ArrayList<Thread>();
        System.err.println("Creating and starting threads...");
        for (int x = 0; x < 3; ++x) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    BlogServiceTest.this.authenticationComponent.setCurrentUser(BlogServiceTest.USER_ONE);
                    try {
                        for (int y = 0; y < 3; ++y) {
                            BlogServiceTest.this.off_testPostTags();
                            BlogServiceTest.this.off_testClearTags();
                        }
                        System.err.println("------------- SUCCEEDED ---------------");
                    }
                    catch (Exception e) {
                        System.err.println("------------- ERROR ---------------");
                        exceptions.add(e);
                        e.printStackTrace();
                        return;
                    }
                }
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        System.err.println("------------- STACK TRACES ---------------");
        for (Exception e : exceptions) {
            e.printStackTrace();
        }
        System.err.println("------------- STACK TRACES END ---------------");
        if (exceptions.size() > 0) {
            throw exceptions.get(0);
        }
    }

    public void off_testPostTags() throws Exception {
        String[] tags = new String[]{"first", "test"};
        JSONObject item = this.createPost("tagtest", "tagtest", tags, false, 200);
        BlogServiceTest.assertEquals((int)2, (int)item.getJSONArray("tags").length());
        BlogServiceTest.assertEquals((Object)"first", (Object)item.getJSONArray("tags").get(0));
        BlogServiceTest.assertEquals((Object)"test", (Object)item.getJSONArray("tags").get(1));
        item = this.updatePost(item.getString("name"), null, null, new String[]{"First", "Test", "Second"}, false, 200);
        BlogServiceTest.assertEquals((int)3, (int)item.getJSONArray("tags").length());
        BlogServiceTest.assertEquals((Object)"first", (Object)item.getJSONArray("tags").get(0));
        BlogServiceTest.assertEquals((Object)"test", (Object)item.getJSONArray("tags").get(1));
        BlogServiceTest.assertEquals((Object)"second", (Object)item.getJSONArray("tags").get(2));
    }

    public void off_testClearTags() throws Exception {
        String[] tags = new String[]{"abc", "def"};
        JSONObject item = this.createPost("tagtest", "tagtest", tags, false, 200);
        BlogServiceTest.assertEquals((int)2, (int)item.getJSONArray("tags").length());
        item = this.updatePost(item.getString("name"), null, null, new String[0], false, 200);
        BlogServiceTest.assertEquals((int)0, (int)item.getJSONArray("tags").length());
    }

    public void testBlogPermission() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String siteName = SITE_SHORT_NAME_BLOG + GUID.generate();
        this.siteService.createSite("BlogSitePreset", siteName, "BlogSiteTitle", "BlogSiteDescription", SiteVisibility.PUBLIC);
        String userName = USER_ONE + GUID.generate();
        this.createUser(userName, "SiteCollaborator", siteName);
        this.checkBlogPermissions(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        this.checkBlogPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(siteName);
        this.authenticationComponent.setCurrentUser(userName);
        siteName = SITE_SHORT_NAME_BLOG + GUID.generate();
        this.siteService.createSite("BlogSitePreset", siteName, "BlogSiteTitle", "BlogSiteDescription", SiteVisibility.PUBLIC);
        this.checkBlogPermissions(siteName);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.checkBlogPermissions(siteName);
        this.siteService.deleteSite(siteName);
        this.personService.deletePerson(userName);
    }

    private void checkBlogPermissions(String siteName) throws Exception {
        String url = "/api/blog/site/" + siteName + "/blog";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertTrue((String)"The user sould have permission to create a new blog.", (boolean)result.getJSONObject("item").getJSONObject("permissions").getBoolean("create"));
    }
}

