/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.repo.solr.AlfrescoModel;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AlfrescoModelGet
extends AbstractWebScript {
    protected static final Log logger = LogFactory.getLog(AlfrescoModelGet.class);
    private NamespaceService namespaceService;
    private SearchTrackingComponent searchTrackingComponent;

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) {
        try {
            this.handle(req, res);
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    private void handle(WebScriptRequest req, WebScriptResponse res) throws JSONException, IOException {
        String modelQName = req.getParameter("modelQName");
        if (modelQName == null) {
            throw new WebScriptException(400, "URL parameter 'modelQName' not provided.");
        }
        ModelDefinition.XMLBindingType bindingType = ModelDefinition.XMLBindingType.DEFAULT;
        AlfrescoModel model = this.searchTrackingComponent.getModel(QName.createQName((String)modelQName));
        res.setHeader("XAlfresco-modelChecksum", String.valueOf(model.getModelDef().getChecksum(bindingType)));
        model.getModelDef().toXML(bindingType, res.getOutputStream());
    }
}

