/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class NodeRating
implements Serializable,
Comparable<NodeRating>,
ExpectedComparison {
    private static final long serialVersionUID = 2855422270577730898L;
    private String nodeId;
    private String ratingScheme;
    private String ratedAt;
    private Object myRating;
    private Aggregate aggregate;

    public NodeRating(String ratingScheme, Object myRating) {
        this.ratingScheme = ratingScheme;
        this.myRating = myRating;
    }

    public NodeRating(String ratingScheme, Object myRating, Aggregate aggregate) {
        this.ratingScheme = ratingScheme;
        this.myRating = myRating;
        this.aggregate = aggregate;
    }

    public NodeRating(String nodeId, String ratingScheme, String ratedAt, Object myRating, Aggregate aggregate) {
        this.nodeId = nodeId;
        this.ratingScheme = ratingScheme;
        this.ratedAt = ratedAt;
        this.myRating = myRating;
        this.aggregate = aggregate;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public Object getMyRating() {
        return this.myRating;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getId() {
        return this.ratingScheme;
    }

    public String getRatedAt() {
        return this.ratedAt;
    }

    public String toString() {
        return "NodeRating [ratingScheme=" + this.ratingScheme + ", ratedAt=" + this.ratedAt + "]";
    }

    public static NodeRating parseNodeRating(String nodeId, JSONObject jsonObject) {
        String ratingScheme = (String)jsonObject.get((Object)"id");
        String ratedAt = (String)jsonObject.get((Object)"ratedAt");
        Object myRating = jsonObject.get((Object)"myRating");
        JSONObject aggregateJSON = (JSONObject)jsonObject.get((Object)"aggregate");
        Long numRatings = (Long)aggregateJSON.get((Object)"numberOfRatings");
        Double average = (Double)aggregateJSON.get((Object)"average");
        Aggregate aggregate = new Aggregate(numRatings != null ? Integer.valueOf(numRatings.intValue()) : null, average != null ? Float.valueOf(average.floatValue()) : null);
        NodeRating nodeRating = new NodeRating(nodeId, ratingScheme, ratedAt, myRating, aggregate);
        return nodeRating;
    }

    public static PublicApiClient.ListResponse<NodeRating> parseNodeRatings(String nodeId, JSONObject jsonObject) {
        ArrayList<NodeRating> nodeRatings = new ArrayList<NodeRating>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            nodeRatings.add(NodeRating.parseNodeRating(nodeId, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<NodeRating> resp = new PublicApiClient.ListResponse<NodeRating>(paging, nodeRatings);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject nodeRatingJSON = new JSONObject();
        nodeRatingJSON.put((Object)"myRating", this.getMyRating());
        nodeRatingJSON.put((Object)"id", (Object)this.getId());
        return nodeRatingJSON;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.ratingScheme == null ? 0 : this.ratingScheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeRating other = (NodeRating)obj;
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        return !(this.ratingScheme == null ? other.ratingScheme != null : !this.ratingScheme.equals(other.ratingScheme));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof NodeRating));
        NodeRating other = (NodeRating)o;
        AssertUtil.assertEquals("nodeId", this.nodeId, other.getNodeId());
        AssertUtil.assertEquals("ratingScheme", this.ratingScheme, other.getId());
        DateFormat dateFormat = PublicApiDateFormat.getDateFormat();
        try {
            if (this.getRatedAt() != null) {
                Date date1 = dateFormat.parse(this.getRatedAt());
                Date date2 = dateFormat.parse(other.getRatedAt());
                Assert.assertTrue((date2.equals(date1) || date2.after(date1) ? 1 : 0) != 0);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        AssertUtil.assertEquals("myRating", this.myRating, other.getMyRating());
        if (this.aggregate != null) {
            this.aggregate.expected(other.getAggregate());
        }
    }

    @Override
    public int compareTo(NodeRating other) {
        return this.ratingScheme.compareTo(other.getId());
    }

    public static class Aggregate
    implements ExpectedComparison {
        private Integer numberOfRatings;
        private Float average;

        public Aggregate(Integer numberOfRatings, Float average) {
            this.numberOfRatings = numberOfRatings;
            this.average = average;
        }

        public Integer getNumberOfRatings() {
            return this.numberOfRatings;
        }

        public Float getAverage() {
            return this.average;
        }

        public String toString() {
            return "Aggregate [numberOfRatings=" + this.numberOfRatings + ", average=" + this.average + "]";
        }

        @Override
        public void expected(Object o) {
            Assert.assertTrue((boolean)(o instanceof Aggregate));
            Aggregate other = (Aggregate)o;
            AssertUtil.assertEquals("numberOfRatings", this.numberOfRatings, other.getNumberOfRatings());
            AssertUtil.assertEquals("average", this.average, other.getAverage());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Aggregate other = (Aggregate)obj;
            if (this.average == null ? other.average != null : !this.average.equals(other.average)) {
                return false;
            }
            return !(this.numberOfRatings == null ? other.numberOfRatings != null : !this.numberOfRatings.equals(other.numberOfRatings));
        }
    }
}

