/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.service.namespace.QName;

public class WebDAVProperty {
    private String m_strName = null;
    private String m_strNamespaceUri = "DAV:";
    private String m_strNamespaceName = null;
    private String m_strValue = null;

    public WebDAVProperty(String strName, String strNamespaceUri, String strNamespaceName, String strValue) {
        this(strName, strNamespaceUri, strNamespaceName);
        this.m_strValue = strValue;
    }

    public WebDAVProperty(String strName, String strNamespaceUri, String strNamespaceName) {
        this(strName);
        this.m_strNamespaceUri = strNamespaceUri;
        this.m_strNamespaceName = strNamespaceName;
    }

    public WebDAVProperty(String strName) {
        this.m_strName = strName;
    }

    public String getName() {
        return this.m_strName;
    }

    public String getNamespaceUri() {
        return this.m_strNamespaceUri;
    }

    public final boolean hasNamespaceName() {
        return this.m_strNamespaceName != null;
    }

    public String getNamespaceName() {
        return this.m_strNamespaceName;
    }

    public String getValue() {
        return this.m_strValue;
    }

    public void setValue(String strValue) {
        this.m_strValue = strValue;
    }

    public QName createQName() {
        return QName.createQName((String)this.m_strNamespaceUri, (String)this.m_strName);
    }

    public boolean isProtected() {
        return "getcontentlength".equals(this.m_strName) || "getetag".equals(this.m_strName) || "getlastmodified".equals(this.m_strName) || "lockdiscovery".equals(this.m_strName) || "resourcetype".equals(this.m_strName) || "supportedlock".equals(this.m_strName);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append("=");
        str.append(this.getValue());
        str.append(",URI=");
        str.append(this.getNamespaceUri());
        if (this.hasNamespaceName()) {
            str.append(",");
            str.append(this.getNamespaceName());
        }
        return str.toString();
    }
}

