/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.solr.SOLRSerializer;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SOLRSerializerTest {
    @Test
    public void testDateSerializer() {
        SOLRSerializer.SOLRTypeConverter typeConverter = new SOLRSerializer.SOLRTypeConverter(null);
        this.trip(typeConverter, "1912-01-01T00:40:00-06:00", "1912-01-01T06:40:00.000Z");
        this.trip(typeConverter, "1812-01-01T00:40:00-06:00", "1812-01-01T06:40:00.000Z");
        this.trip(typeConverter, "1845-01-01T00:40:00-06:00", "1845-01-01T06:40:00.000Z");
        this.trip(typeConverter, "1846-01-01T00:40:00-06:00", "1846-01-01T06:40:00.000Z");
        this.trip(typeConverter, "1847-01-01T00:40:00-06:00", "1847-01-01T06:40:00.000Z");
        this.trip(typeConverter, "1848-01-01T00:40:00-06:00", "1848-01-01T06:40:00.000Z");
    }

    private void trip(SOLRSerializer.SOLRTypeConverter typeConverter, String iso, String zulu) {
        Date testDate = ISO8601DateFormat.parse((String)iso);
        String strDate = (String)typeConverter.INSTANCE.convert(String.class, (Object)testDate);
        Assert.assertEquals((Object)zulu, (Object)strDate);
    }

    @Test
    public void testChildAssociationRefToJSONString() {
        SOLRSerializer solrSerializer = new SOLRSerializer();
        solrSerializer.setDictionaryService((DictionaryService)Mockito.mock(DictionaryService.class));
        solrSerializer.setNamespaceService((NamespaceService)Mockito.mock(NamespaceService.class));
        solrSerializer.init();
        QName childQName = QName.createQName((String)"hello", (String)"wo\rld");
        ChildAssociationRef childAssociationRef = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, new NodeRef("workspace://SpacesStore/parent"), childQName, new NodeRef("workspace://SpacesStore/child"));
        String validJsonString = solrSerializer.serializeToJSONString((Serializable)childAssociationRef);
        String jsonObjectString = String.format("{ \"key\": \"%s\" }", validJsonString);
        try {
            new JSONObject(jsonObjectString);
        }
        catch (JSONException e) {
            Assert.assertTrue((String)("JSON String " + jsonObjectString + " is not a valid JSON"), (boolean)false);
        }
    }

    @Test
    public void testAssociationRefToJSONString() {
        SOLRSerializer solrSerializer = new SOLRSerializer();
        solrSerializer.setDictionaryService((DictionaryService)Mockito.mock(DictionaryService.class));
        solrSerializer.setNamespaceService((NamespaceService)Mockito.mock(NamespaceService.class));
        solrSerializer.init();
        AssociationRef associationRef = new AssociationRef(new NodeRef("workspace://SpacesStore/wo\rld"), ContentModel.ASSOC_ATTACHMENTS, new NodeRef("workspace://SpacesStore/hello"));
        String validJsonString = solrSerializer.serializeToJSONString((Serializable)associationRef);
        String jsonObjectString = String.format("{ \"key\": \"%s\" }", validJsonString);
        try {
            new JSONObject(jsonObjectString);
        }
        catch (JSONException e) {
            Assert.assertTrue((String)("JSON String " + jsonObjectString + " is not a valid JSON"), (boolean)false);
        }
    }
}

