/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Collection;
import java.util.Set;
import org.alfresco.repo.dictionary.CMMDownloadTestUtil;
import org.alfresco.rest.api.model.CustomModel;
import org.alfresco.rest.api.model.CustomModelDownload;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.rest.api.tests.BaseCustomModelApiTest;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestCustomModelExport
extends BaseCustomModelApiTest {
    private static final long PAUSE_TIME = 1000L;
    private CMMDownloadTestUtil downloadTestUtil;

    @Override
    public void setup() throws Exception {
        super.setup();
        this.downloadTestUtil = new CMMDownloadTestUtil(this.applicationContext);
    }

    @Override
    public void tearDown() throws Exception {
        this.downloadTestUtil.cleanup();
        super.tearDown();
    }

    @Test
    public void testCreateDownload() throws Exception {
        this.setRequestContext(this.customModelAdmin);
        String modelName = "testModel" + System.currentTimeMillis();
        String modelExportFileName = modelName + ".xml";
        String shareExtExportFileName = "CMM_" + modelName + "_module.xml";
        Pair<String, String> namespacePair = this.getTestNamespaceUriPrefixPair();
        this.createCustomModel(modelName, namespacePair, CustomModel.ModelStatus.DRAFT, null, "Mark Moe");
        String typeBaseName = "testTypeBase" + System.currentTimeMillis();
        this.createTypeAspect(CustomType.class, modelName, typeBaseName, "test typeBase title", "test typeBase Desc", "cm:content");
        this.downloadTestUtil.createShareExtModule(modelName);
        this.setRequestContext(this.nonAdminUserName);
        this.post("cmm/" + modelName + "/download", RestApiUtil.toJsonAsString(new CustomModelDownload()), this.getExtModuleQS(false), 403);
        this.setRequestContext(this.customModelAdmin);
        HttpResponse response = this.post("cmm/" + modelName + "/download", RestApiUtil.toJsonAsString(new CustomModelDownload()), this.getExtModuleQS(false), 201);
        CustomModelDownload returnedDownload = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelDownload.class);
        Assert.assertNotNull((Object)returnedDownload);
        Assert.assertNotNull((Object)returnedDownload.getNodeRef());
        NodeRef downloadNode = new NodeRef(returnedDownload.getNodeRef());
        DownloadStatus status = this.downloadTestUtil.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = this.downloadTestUtil.getDownloadStatus(downloadNode);
        }
        Set entries = this.downloadTestUtil.getDownloadEntries(downloadNode);
        Assert.assertEquals((long)1L, (long)entries.size());
        String modelEntry = this.downloadTestUtil.getDownloadEntry((Collection)entries, modelExportFileName);
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)modelEntry, (Object)modelExportFileName);
        response = this.post("cmm/" + modelName + "/download", RestApiUtil.toJsonAsString(new CustomModelDownload()), this.getExtModuleQS(true), 201);
        returnedDownload = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), CustomModelDownload.class);
        Assert.assertNotNull((Object)returnedDownload);
        Assert.assertNotNull((Object)returnedDownload.getNodeRef());
        downloadNode = new NodeRef(returnedDownload.getNodeRef());
        status = this.downloadTestUtil.getDownloadStatus(downloadNode);
        while (status.getStatus() == DownloadStatus.Status.PENDING) {
            Thread.sleep(1000L);
            status = this.downloadTestUtil.getDownloadStatus(downloadNode);
        }
        entries = this.downloadTestUtil.getDownloadEntries(downloadNode);
        Assert.assertEquals((long)2L, (long)entries.size());
        modelEntry = this.downloadTestUtil.getDownloadEntry((Collection)entries, modelExportFileName);
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)modelEntry, (Object)modelExportFileName);
        String shareExtEntry = this.downloadTestUtil.getDownloadEntry((Collection)entries, shareExtExportFileName);
        Assert.assertNotNull((Object)shareExtEntry);
        Assert.assertEquals((Object)shareExtEntry, (Object)shareExtExportFileName);
    }

    private String getExtModuleQS(boolean withShareExtModule) {
        return "?extModule=" + withShareExtModule;
    }
}

