/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.rest.api.ContentStorageInformation;
import org.alfresco.rest.api.model.ArchiveContentRequest;
import org.alfresco.rest.api.model.ContentStorageInfo;
import org.alfresco.rest.api.model.RestoreArchivedContentRequest;
import org.alfresco.rest.api.nodes.NodeStorageInfoRelation;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NodeStorageInfoRelationTest
extends TestCase {
    private static final String DUMMY_NODE_ID = "dummy-node-id";
    private static final String CONTENT_PROP_NAME = "cm:content";
    private static final NodeRef DUMMY_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-node-id");
    @Mock
    private ContentStorageInformation storageInformation;
    @Mock
    private Parameters params;
    @Mock
    private WithResponse withResponse;
    @InjectMocks
    private NodeStorageInfoRelation objectUnderTest;

    @Test
    public void shouldProperlyReturnStorageInfo() {
        ContentStorageInfo expectedStorageInfo = new ContentStorageInfo();
        Map<String, String> storageProps = Map.of("x-amz-storage-class", "INTELLIGENT_TIERING", "x-alf-archived", "false");
        expectedStorageInfo.setStorageProperties(storageProps);
        expectedStorageInfo.setId(CONTENT_PROP_NAME);
        Mockito.when((Object)this.storageInformation.getStorageInfo(DUMMY_NODE_REF, CONTENT_PROP_NAME, this.params)).thenReturn((Object)expectedStorageInfo);
        ContentStorageInfo storageInfo = this.objectUnderTest.readById(DUMMY_NODE_ID, CONTENT_PROP_NAME, this.params);
        Assert.assertEquals(storageProps, (Object)storageInfo.getStorageProperties());
        Assert.assertEquals((Object)CONTENT_PROP_NAME, (Object)storageInfo.getId());
    }

    @Test
    public void shouldProperlyRequestArchiveContent() {
        ArchiveContentRequest archiveContentRequest = new ArchiveContentRequest();
        Mockito.when((Object)this.storageInformation.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveContentRequest)).thenReturn((Object)true);
        this.objectUnderTest.requestArchiveContent(DUMMY_NODE_ID, CONTENT_PROP_NAME, archiveContentRequest, this.params, this.withResponse);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.times((int)1))).setStatus(200);
    }

    @Test
    public void shouldFailsOnRequestArchiveContent() {
        ArchiveContentRequest archiveContentRequest = new ArchiveContentRequest();
        Mockito.when((Object)this.storageInformation.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveContentRequest)).thenReturn((Object)false);
        this.objectUnderTest.requestArchiveContent(DUMMY_NODE_ID, CONTENT_PROP_NAME, archiveContentRequest, this.params, this.withResponse);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.times((int)1))).setStatus(501);
    }

    @Test
    public void shouldThrowExceptionOnRequestArchiveContent() {
        ArchiveContentRequest archiveContentRequest = new ArchiveContentRequest();
        Mockito.when((Object)this.storageInformation.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveContentRequest)).thenThrow(UnsupportedOperationException.class);
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.objectUnderTest.requestArchiveContent(DUMMY_NODE_ID, CONTENT_PROP_NAME, archiveContentRequest, this.params, this.withResponse));
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.never())).setStatus(501);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.never())).setStatus(200);
    }

    @Test
    public void shouldProperlyRequestRestoreContentFromArchive() {
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        Mockito.when((Object)this.storageInformation.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest)).thenReturn((Object)true);
        this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF.getId(), CONTENT_PROP_NAME, restoreArchivedContentRequest, this.params, this.withResponse);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.times((int)1))).setStatus(202);
    }

    @Test
    public void shouldFailsOnRequestRestoreContentFromArchive() {
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        Mockito.when((Object)this.storageInformation.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest)).thenReturn((Object)false);
        this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF.getId(), CONTENT_PROP_NAME, restoreArchivedContentRequest, this.params, this.withResponse);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.times((int)1))).setStatus(501);
    }

    @Test
    public void shouldThrowExceptionOnRequestRestoreContentFromArchive() {
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        Mockito.when((Object)this.storageInformation.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest)).thenThrow(UnsupportedOperationException.class);
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_ID, CONTENT_PROP_NAME, restoreArchivedContentRequest, this.params, this.withResponse));
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.never())).setStatus(501);
        ((WithResponse)Mockito.verify((Object)this.withResponse, (VerificationMode)Mockito.never())).setStatus(202);
    }
}

