/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.actions.interfaces.ResourceAction;
import org.springframework.http.HttpMethod;

public class ResourceMetadata {
    private final String uniqueId;
    private final RESOURCE_TYPE type;
    private final List<ResourceOperation> operations;
    private final String parentResource;
    @JsonIgnore
    private final Api api;
    private final Set<Class<? extends ResourceAction>> apiDeleted;
    private Set<Class<? extends ResourceAction>> apiNoAuth;

    public ResourceMetadata(String uniqueId, RESOURCE_TYPE type, List<ResourceOperation> operations, Api api, Set<Class<? extends ResourceAction>> apiDeleted, Set<Class<? extends ResourceAction>> apiNoAuth, String parentResource) {
        this.uniqueId = uniqueId;
        this.type = type;
        this.operations = operations == null ? Collections.emptyList() : operations;
        this.api = api;
        this.apiDeleted = apiDeleted == null ? Collections.emptySet() : apiDeleted;
        Set<Object> set = this.apiNoAuth = apiNoAuth == null ? Collections.emptySet() : apiNoAuth;
        this.parentResource = parentResource != null ? (parentResource.startsWith("/") ? parentResource : "/" + parentResource) : null;
    }

    public ResourceOperation getOperation(HttpMethod supportedMethod) {
        for (ResourceOperation ops : this.operations) {
            if (!ops.getHttpMethod().equals((Object)supportedMethod)) continue;
            return ops;
        }
        return null;
    }

    public Class getObjectType(ResourceOperation operation) {
        for (ResourceParameter param : operation.getParameters()) {
            if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)param.getParamType())) continue;
            return param.getDataType();
        }
        return null;
    }

    public boolean isDeleted(Class<? extends ResourceAction> resourceAction) {
        return this.apiDeleted.contains(resourceAction);
    }

    public boolean isNoAuth(Class<? extends ResourceAction> resourceAction) {
        return this.apiNoAuth.contains(resourceAction);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public RESOURCE_TYPE getType() {
        return this.type;
    }

    public Api getApi() {
        return this.api;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceMetadata [api=");
        builder.append(this.api);
        builder.append(", uniqueId=");
        builder.append(this.uniqueId);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", parent=");
        builder.append(this.parentResource);
        builder.append(", operations=");
        builder.append(this.operations);
        builder.append(", apiDeleted=");
        builder.append(this.apiDeleted);
        builder.append(", apiNoAuth=");
        builder.append(this.apiNoAuth);
        builder.append("]");
        return builder.toString();
    }

    public List<ResourceOperation> getOperations() {
        return this.operations;
    }

    protected Set<Class<? extends ResourceAction>> getApiDeleted() {
        return this.apiDeleted;
    }

    public String getParentResource() {
        return this.parentResource;
    }

    public static enum RESOURCE_TYPE {
        ENTITY,
        RELATIONSHIP,
        PROPERTY,
        OPERATION;

    }
}

