/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class SiteContainer
implements Serializable,
ExpectedComparison,
Comparable<SiteContainer> {
    private static final long serialVersionUID = 535206187221924534L;
    private String siteId;
    private String id;
    private String folderId;

    public SiteContainer(String siteId, String folderId, String id) {
        this.siteId = siteId;
        this.folderId = folderId;
        this.id = id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "SiteContainer [siteId=" + this.siteId + ", folderId=" + this.folderId + ", id=" + this.id + "]";
    }

    public static SiteContainer parseSiteContainer(String siteId, JSONObject json) {
        SiteContainer siteContainer = null;
        if (json != null) {
            siteContainer = new SiteContainer(siteId, (String)json.get((Object)"folderId"), (String)json.get((Object)"id"));
        }
        return siteContainer;
    }

    public static PublicApiClient.ListResponse<SiteContainer> parseSiteContainers(JSONObject jsonObject) {
        ArrayList<SiteContainer> siteContainers = new ArrayList<SiteContainer>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            siteContainers.add(SiteContainer.parseSiteContainer(null, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<SiteContainer> resp = new PublicApiClient.ListResponse<SiteContainer>(paging, siteContainers);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject siteContainerJson = new JSONObject();
        siteContainerJson.put((Object)"id", (Object)this.id);
        siteContainerJson.put((Object)"folderId", (Object)this.folderId);
        return siteContainerJson;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof SiteContainer));
        SiteContainer other = (SiteContainer)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("folderId", this.folderId, other.getFolderId());
    }

    @Override
    public int compareTo(SiteContainer o) {
        return this.folderId.compareTo(o.getFolderId());
    }
}

