/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import org.alfresco.repo.security.authentication.AlfrescoSecureContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClearSecurityContextFilter
implements Filter {
    private Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.logClearContextInfo(servletRequest);
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }

    private void logClearContextInfo(ServletRequest servletRequest) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        try {
            String identifiedUserName = null;
            String fullyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
            Context context = ContextHolder.getContext();
            if (context instanceof AlfrescoSecureContext) {
                AlfrescoSecureContext sc = (AlfrescoSecureContext)context;
                identifiedUserName = AuthenticationUtil.getMaskedUsername((Authentication)sc.getRealAuthentication());
            }
            if (context == null && fullyAuthenticatedUser == null) {
                return;
            }
            String newLine = System.lineSeparator();
            String url = null;
            if (servletRequest instanceof HttpServletRequest) {
                url = ((HttpServletRequest)servletRequest).getRequestURL().toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("When clearing out the context for request: ");
            sb.append(url);
            sb.append(newLine);
            sb.append("There was some information still present in the security context for this thread: ");
            sb.append(Thread.currentThread().getName());
            sb.append(newLine);
            if (context != null) {
                if (identifiedUserName != null) {
                    sb.append("Real authenticated user found: " + AuthenticationUtil.maskUsername((String)identifiedUserName));
                    sb.append(newLine);
                } else {
                    sb.append("ContextHolder was not null");
                    sb.append(newLine);
                }
            }
            if (fullyAuthenticatedUser != null) {
                sb.append("Fully authenticated user found: " + AuthenticationUtil.maskUsername((String)fullyAuthenticatedUser));
                sb.append(newLine);
            }
            sb.append("Other information about leaking ticket and tenant information may follow in the log, if org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl and org.alfresco.repo.tenant.TenantContextHolder loggers are set to 'trace'");
            sb.append(newLine);
            this.logger.debug((Object)sb.toString());
        }
        catch (Exception e) {
            this.logger.debug((Object)("Error building proper logging message:" + e.getMessage()), (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

