/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.DeletedResourceException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.ContentInfoImpl;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.tools.RequestReader;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class ResourceWebScriptPut
extends AbstractResourceWebScript
implements ParamsExtractor,
RecognizedParamsExtractor,
RequestReader {
    private static final Log logger = LogFactory.getLog(ResourceWebScriptPut.class);

    public ResourceWebScriptPut() {
        this.setHttpMethod(HttpMethod.PUT);
        this.setParamsExtractor(this);
    }

    @Override
    public Params extractParams(ResourceMetadata resourceMeta, WebScriptRequest req) {
        Map<String, String> resourceVars = this.locator.parseTemplateVars(req.getServiceMatch().getTemplateVars());
        String entityId = resourceVars.get("entityId");
        String relationshipId = resourceVars.get("relationshipId");
        String relationship2Id = resourceVars.get("relationship2Id");
        Params.RecognizedParams params = this.getRecognizedParams(req);
        ResourceOperation operation = resourceMeta.getOperation(HttpMethod.PUT);
        switch (resourceMeta.getType()) {
            case ENTITY: {
                if (StringUtils.isBlank((CharSequence)entityId)) {
                    throw new UnsupportedResourceOperationException("PUT is executed against the instance URL");
                }
                Object putEnt = this.extractJsonContent(req, this.assistant.getJsonHelper(), resourceMeta.getObjectType(operation));
                return Params.valueOf(entityId, params, putEnt, req);
            }
            case RELATIONSHIP: {
                if (StringUtils.isBlank((CharSequence)relationshipId)) {
                    throw new UnsupportedResourceOperationException("PUT is executed against the instance URL");
                }
                Object putRel = this.extractJsonContent(req, this.assistant.getJsonHelper(), resourceMeta.getObjectType(operation));
                if (StringUtils.isNotBlank((CharSequence)relationship2Id)) {
                    ResourceWebScriptHelper.setUniqueId(putRel, relationship2Id);
                    return Params.valueOf(false, entityId, relationshipId, relationship2Id, putRel, null, null, params, null, req);
                }
                ResourceWebScriptHelper.setUniqueId(putRel, relationshipId);
                return Params.valueOf(entityId, relationshipId, params, putRel, req);
            }
            case PROPERTY: {
                String resourceName = resourceVars.get("relationResource");
                String propertyName = resourceVars.get("property");
                if (!StringUtils.isNotBlank((CharSequence)entityId) || !StringUtils.isNotBlank((CharSequence)resourceName)) break;
                if (StringUtils.isNotBlank((CharSequence)propertyName)) {
                    return Params.valueOf(entityId, relationshipId, null, this.getStream(req), propertyName, params, this.getContentInfo(req), req);
                }
                return Params.valueOf(entityId, null, null, this.getStream(req), resourceName, params, this.getContentInfo(req), req);
            }
        }
        throw new UnsupportedResourceOperationException("PUT not supported for this request.");
    }

    private BasicContentInfo getContentInfo(WebScriptRequest req) {
        String encoding = "UTF-8";
        Object contentType = "application/octet-stream";
        if (StringUtils.isNotEmpty((CharSequence)req.getContentType())) {
            MediaType media = MediaType.parseMediaType((String)req.getContentType());
            contentType = media.getType() + "/" + media.getSubtype();
            if (media.getCharset() != null) {
                encoding = media.getCharset().toString();
            }
        }
        return new ContentInfoImpl((String)contentType, encoding, -1L, Locale.getDefault());
    }

    private InputStream getStream(WebScriptRequest req) {
        try {
            if (req instanceof WebScriptServletRequest) {
                WebScriptServletRequest servletRequest = (WebScriptServletRequest)req;
                return servletRequest.getHttpServletRequest().getInputStream();
            }
            if (req instanceof WrappingWebScriptRequest) {
                WrappingWebScriptRequest wrappedRequest = (WrappingWebScriptRequest)req;
                return wrappedRequest.getContent().getInputStream();
            }
        }
        catch (IOException error) {
            logger.warn((Object)"Failed to get the input stream.", (Throwable)error);
        }
        return null;
    }

    @Override
    public Object executeAction(ResourceWithMetadata resource, Params params, WithResponse withResponse) throws Throwable {
        switch (resource.getMetaData().getType()) {
            case ENTITY: {
                if (EntityResourceAction.Update.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.Update.class)) {
                        throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                    }
                    EntityResourceAction.Update updateEnt = (EntityResourceAction.Update)resource.getResource();
                    Object result = updateEnt.update(params.getEntityId(), params.getPassedIn(), params);
                    return result;
                }
                if (resource.getMetaData().isDeleted(EntityResourceAction.UpdateWithResponse.class)) {
                    throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                }
                EntityResourceAction.UpdateWithResponse updateEnt = (EntityResourceAction.UpdateWithResponse)resource.getResource();
                Object result = updateEnt.update(params.getEntityId(), params.getPassedIn(), params, withResponse);
                return result;
            }
            case RELATIONSHIP: {
                if (RelationshipResourceAction.UpdateWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.UpdateWithResponse.class)) {
                        throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceAction.UpdateWithResponse relationUpdater = (RelationshipResourceAction.UpdateWithResponse)resource.getResource();
                    Object relResult = relationUpdater.update(params.getEntityId(), params.getPassedIn(), params, withResponse);
                    return relResult;
                }
                if (resource.getMetaData().isDeleted(RelationshipResourceAction.Update.class)) {
                    throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                }
                RelationshipResourceAction.Update relationUpdater = (RelationshipResourceAction.Update)resource.getResource();
                Object relResult = relationUpdater.update(params.getEntityId(), params.getPassedIn(), params);
                return relResult;
            }
            case PROPERTY: {
                if (BinaryResourceAction.Update.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(BinaryResourceAction.Update.class)) {
                        throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                    }
                    BinaryResourceAction.Update binUpdater = (BinaryResourceAction.Update)resource.getResource();
                    return binUpdater.updateProperty(params.getEntityId(), params.getContentInfo(), params.getStream(), params);
                }
                if (BinaryResourceAction.UpdateWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(BinaryResourceAction.UpdateWithResponse.class)) {
                        throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                    }
                    BinaryResourceAction.UpdateWithResponse binUpdater = (BinaryResourceAction.UpdateWithResponse)resource.getResource();
                    return binUpdater.updateProperty(params.getEntityId(), params.getContentInfo(), params.getStream(), params, withResponse);
                }
                if (RelationshipResourceBinaryAction.Update.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.Update.class)) {
                        throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                    }
                    RelationshipResourceBinaryAction.Update binUpdater = (RelationshipResourceBinaryAction.Update)resource.getResource();
                    return binUpdater.updateProperty(params.getEntityId(), params.getRelationshipId(), params.getContentInfo(), params.getStream(), params);
                }
                if (!RelationshipResourceBinaryAction.UpdateWithResponse.class.isAssignableFrom(resource.getResource().getClass())) break;
                if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.UpdateWithResponse.class)) {
                    throw new DeletedResourceException("(UPDATE) " + resource.getMetaData().getUniqueId());
                }
                RelationshipResourceBinaryAction.UpdateWithResponse binUpdater = (RelationshipResourceBinaryAction.UpdateWithResponse)resource.getResource();
                return binUpdater.updateProperty(params.getEntityId(), params.getRelationshipId(), params.getContentInfo(), params.getStream(), params, withResponse);
            }
        }
        throw new UnsupportedResourceOperationException("PUT not supported for Actions");
    }
}

