/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.rest.antlr.WhereClauseParser;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;

public class WhereProperty
extends HashMap<ClauseType, Collection<String>> {
    private final String name;
    private boolean validateStrictly;

    public WhereProperty(String name, ClauseType clauseType, Collection<String> values) {
        super(Map.of(clauseType, new HashSet<String>(values)));
        this.name = name;
        this.validateStrictly = true;
    }

    public WhereProperty(String name, ClauseType clauseType, Collection<String> values, boolean validateStrictly) {
        this(name, clauseType, values);
        this.validateStrictly = validateStrictly;
    }

    public String getName() {
        return this.name;
    }

    public void addValuesToType(ClauseType clauseType, Collection<String> values) {
        if (this.containsKey((Object)clauseType)) {
            ((Collection)this.get((Object)clauseType)).addAll(values);
        } else {
            this.put(clauseType, new HashSet<String>(values));
        }
    }

    public boolean containsType(ClauseType clauseType) {
        return this.containsKey((Object)clauseType);
    }

    public boolean containsType(int clauseType, boolean negated) {
        return this.containsKey((Object)ClauseType.of(clauseType, negated));
    }

    public boolean containsAllTypes(ClauseType ... clauseType) {
        return Arrays.stream(clauseType).distinct().filter(this::containsKey).count() == (long)clauseType.length;
    }

    public boolean containsAnyOfTypes(ClauseType ... clauseType) {
        return Arrays.stream(clauseType).distinct().anyMatch(this::containsKey);
    }

    public Collection<String> getExpectedValuesFor(ClauseType clauseType) {
        this.verifyAllClausesPresence(clauseType);
        return (Collection)this.get((Object)clauseType);
    }

    public HashMap<ClauseType, Collection<String>> getExpectedValuesForAllOf(ClauseType ... clauseTypes) {
        this.verifyAllClausesPresence(clauseTypes);
        return Arrays.stream(clauseTypes).distinct().collect(Collectors.toMap(type -> type, this::get, (type1, type2) -> type1, MultiTypeNegatableValuesMap::new));
    }

    public HashMap<ClauseType, Collection<String>> getExpectedValuesForAnyOf(ClauseType ... clauseTypes) {
        this.verifyAnyClausesPresence(clauseTypes);
        return Arrays.stream(clauseTypes).distinct().collect(Collectors.toMap(type -> type, this::get, (type1, type2) -> type1, MultiTypeNegatableValuesMap::new));
    }

    public Collection<String> getExpectedValuesFor(int clauseType, boolean negated) {
        this.verifyAllClausesPresence(ClauseType.of(clauseType, negated));
        return (Collection)this.get((Object)ClauseType.of(clauseType, negated));
    }

    public NegatableValuesMap getExpectedValuesFor(int clauseType) {
        this.verifyAllClausesPresence(clauseType);
        NegatableValuesMap values = new NegatableValuesMap();
        ClauseType type = ClauseType.of(clauseType);
        ClauseType negatedType = type.negate();
        if (this.containsKey((Object)type)) {
            values.put(false, (Collection)this.get((Object)type));
        }
        if (this.containsKey((Object)negatedType)) {
            values.put(true, (Collection)this.get((Object)negatedType));
        }
        return values;
    }

    public MultiTypeNegatableValuesMap getExpectedValuesForAllOf(int ... clauseTypes) {
        this.verifyAllClausesPresence(clauseTypes);
        return this.getExpectedValuesFor(clauseTypes);
    }

    public MultiTypeNegatableValuesMap getExpectedValuesForAnyOf(int ... clauseTypes) {
        this.verifyAnyClausesPresence(clauseTypes);
        return this.getExpectedValuesFor(clauseTypes);
    }

    private MultiTypeNegatableValuesMap getExpectedValuesFor(int ... clauseTypes) {
        MultiTypeNegatableValuesMap values = new MultiTypeNegatableValuesMap();
        Arrays.stream(clauseTypes).distinct().forEach((int clauseType) -> {
            ClauseType type = ClauseType.of(clauseType);
            ClauseType negatedType = type.negate();
            if (this.containsKey((Object)type)) {
                values.put(type, (Collection)this.get((Object)type));
            }
            if (this.containsKey((Object)negatedType)) {
                values.put(negatedType, (Collection)this.get((Object)negatedType));
            }
        });
        return values;
    }

    private void verifyAllClausesPresence(ClauseType ... clauseTypes) {
        if (this.validateStrictly) {
            Arrays.stream(clauseTypes).distinct().forEach((? super T clauseType) -> {
                if (!this.containsType((ClauseType)((Object)clauseType))) {
                    throw new InvalidQueryException((Object)String.format("Where query error: property with name: %s expects clause: %s", this.name, WhereClauseParser.tokenNames[clauseType.getTypeNumber()]));
                }
            });
        }
    }

    private void verifyAllClausesPresence(int ... clauseTypes) {
        if (this.validateStrictly) {
            Arrays.stream(clauseTypes).distinct().forEach((int clauseType) -> {
                if (!this.containsType(clauseType, false) && !this.containsType(clauseType, true)) {
                    throw new InvalidQueryException((Object)String.format("Where query error: property with name: %s expects clause: %s", this.name, WhereClauseParser.tokenNames[clauseType]));
                }
            });
        }
    }

    private void verifyAnyClausesPresence(ClauseType ... clauseTypes) {
        if (this.validateStrictly && !this.containsAnyOfTypes(clauseTypes)) {
            throw new InvalidQueryException((Object)String.format("Where query error: property with name: %s expects at least one of clauses: %s", this.name, Arrays.stream(clauseTypes).map(type -> WhereClauseParser.tokenNames[type.getTypeNumber()]).collect(Collectors.toList())));
        }
    }

    private void verifyAnyClausesPresence(int ... clauseTypes) {
        Collection expectedTypes;
        if (this.validateStrictly && !this.containsAnyOfTypes((ClauseType[])(expectedTypes = (Collection)Arrays.stream(clauseTypes).distinct().boxed().flatMap(type -> Stream.of(ClauseType.of(type), ClauseType.of(type, true))).collect(Collectors.toSet())).toArray(ClauseType[]::new))) {
            throw new InvalidQueryException((Object)String.format("Where query error: property with name: %s expects at least one of clauses: %s", this.name, Arrays.stream(clauseTypes).mapToObj(type -> WhereClauseParser.tokenNames[type]).collect(Collectors.toList())));
        }
    }

    public static enum ClauseType {
        EQUALS(8),
        NOT_EQUALS(8, true),
        GREATER_THAN(10),
        NOT_GREATER_THAN(10, true),
        LESS_THAN(18),
        NOT_LESS_THAN(18, true),
        GREATER_THAN_OR_EQUALS(11),
        NOT_GREATER_THAN_OR_EQUALS(11, true),
        LESS_THAN_OR_EQUALS(19),
        NOT_LESS_THAN_OR_EQUALS(19, true),
        BETWEEN(5),
        NOT_BETWEEN(5, true),
        IN(16),
        NOT_IN(16, true),
        MATCHES(20),
        NOT_MATCHES(20, true),
        EXISTS(9),
        NOT_EXISTS(9, true);

        private final int typeNumber;
        private final boolean negated;

        private ClauseType(int typeNumber) {
            this.typeNumber = typeNumber;
            this.negated = false;
        }

        private ClauseType(int typeNumber, boolean negated) {
            this.typeNumber = typeNumber;
            this.negated = negated;
        }

        public static ClauseType of(int type) {
            return ClauseType.of(type, false);
        }

        public static ClauseType of(int type, boolean negated) {
            return Arrays.stream(ClauseType.values()).filter(clauseType -> clauseType.typeNumber == type && clauseType.negated == negated).findFirst().orElseThrow();
        }

        public ClauseType negate() {
            return ClauseType.of(this.typeNumber, !this.negated);
        }

        public int getTypeNumber() {
            return this.typeNumber;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }

    public static class NegatableValuesMap
    extends HashMap<Boolean, Collection<String>> {
        public Collection<String> skipNegated() {
            return (Collection)this.get(false);
        }

        public Collection<String> onlyNegated() {
            return (Collection)this.get(true);
        }
    }

    public static class MultiTypeNegatableValuesMap
    extends HashMap<ClauseType, Collection<String>> {
        public Map<Integer, Collection<String>> skipNegated() {
            return this.keySet().stream().filter(Predicate.not(ClauseType::isNegated)).collect(Collectors.toMap(key -> key.typeNumber, this::get));
        }

        public Collection<String> skipNegated(int clauseType) {
            return (Collection)this.get((Object)ClauseType.of(clauseType));
        }

        public Map<Integer, Collection<String>> onlyNegated() {
            return this.keySet().stream().filter(Predicate.not(ClauseType::isNegated)).collect(Collectors.toMap(key -> key.typeNumber, this::get));
        }

        public Collection<String> onlyNegated(int clauseType) {
            return (Collection)this.get((Object)ClauseType.of(clauseType, true));
        }
    }
}

