/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.people;

import org.alfresco.rest.api.Groups;
import org.alfresco.rest.api.model.Group;
import org.alfresco.rest.api.people.PeopleEntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="groups", entityResource=PeopleEntityResource.class, title="Person Groups")
public class PersonGroupsRelation
implements RelationshipResourceAction.Read<Group>,
InitializingBean {
    private Groups groups;

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"groups", (Object)this.groups);
    }

    @Override
    public CollectionWithPagingInfo<Group> readAll(String personId, Parameters params) {
        return this.groups.getGroupsByPersonId(personId, params);
    }
}

