/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.rest.api.groups.GroupsEntityResource;
import org.alfresco.rest.framework.resource.EmbeddedEntityResource;
import org.alfresco.rest.framework.resource.UniqueId;

public class SiteGroup
implements Comparable<SiteGroup> {
    private String role;
    private String id;

    public SiteGroup() {
    }

    public SiteGroup(String id, String role) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
        this.id = id;
    }

    public static SiteGroup getMemberOfSite(String id, String role) {
        return new SiteGroup(id, role);
    }

    @JsonProperty(value="id")
    @UniqueId
    @EmbeddedEntityResource(propertyName="group", entityResource=GroupsEntityResource.class)
    public String getId() {
        return this.id;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
    }

    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteGroup other = (SiteGroup)obj;
        if (this.role != other.role) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(SiteGroup o) {
        int i = this.id.compareTo(o.getId());
        if (i == 0) {
            i = this.role.compareTo(o.getRole());
        }
        return i;
    }

    public String toString() {
        return "SiteGroup [role='" + this.role + "', id='" + this.id + "', role='" + this.role + "']";
    }
}

