/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.List;
import java.util.Objects;
import org.alfresco.rest.api.model.Association;
import org.alfresco.rest.api.model.ClassDefinition;
import org.alfresco.rest.api.model.Model;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;

public abstract class AbstractClass
extends ClassDefinition
implements Comparable<AbstractClass> {
    protected String id;
    protected String title;
    protected String description;
    protected String parentId;
    protected Boolean isContainer = null;
    protected Boolean isArchive = null;
    protected Boolean includedInSupertypeQuery = null;
    protected List<String> mandatoryAspects = null;
    protected List<Association> associations = null;
    protected Model model;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Boolean getIsContainer() {
        return this.isContainer;
    }

    public void setIsContainer(Boolean isContainer) {
        this.isContainer = isContainer;
    }

    public Boolean getIsArchive() {
        return this.isArchive;
    }

    public void setIsArchive(Boolean isArchive) {
        this.isArchive = isArchive;
    }

    public Boolean getIncludedInSupertypeQuery() {
        return this.includedInSupertypeQuery;
    }

    public void setIncludedInSupertypeQuery(Boolean includedInSupertypeQuery) {
        this.includedInSupertypeQuery = includedInSupertypeQuery;
    }

    public List<String> getMandatoryAspects() {
        return this.mandatoryAspects;
    }

    public void setMandatoryAspects(List<String> mandatoryAspects) {
        this.mandatoryAspects = mandatoryAspects;
    }

    public List<Association> getAssociations() {
        return this.associations;
    }

    public void setAssociations(List<Association> associations) {
        this.associations = associations;
    }

    String getParentNameAsString(QName parentQName) {
        if (parentQName != null) {
            return parentQName.toPrefixString();
        }
        return null;
    }

    Model getModelInfo(org.alfresco.service.cmr.dictionary.ClassDefinition classDefinition, MessageLookup messageLookup) {
        ModelDefinition modelDefinition = classDefinition.getModel();
        String prefix = classDefinition.getName().toPrefixString().split(":")[0];
        NamespaceDefinition namespaceDefinition = modelDefinition.getNamespaces().stream().filter(definition -> definition.getPrefix().equals(prefix)).findFirst().get();
        String modelId = modelDefinition.getName().toPrefixString();
        String author = modelDefinition.getAuthor();
        String description = modelDefinition.getDescription(messageLookup);
        return new Model(modelId, author, description, namespaceDefinition.getUri(), namespaceDefinition.getPrefix());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.parentId, this.properties, this.isContainer, this.isArchive, this.includedInSupertypeQuery, this.mandatoryAspects, this.associations, this.model);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(AbstractClass other) {
        return this.id.compareTo(other.getId());
    }
}

