/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.node.ratings;

import org.alfresco.rest.api.impl.node.ratings.AbstractRatingScheme;
import org.alfresco.rest.api.model.DocumentRatingSummary;
import org.alfresco.rest.api.model.FiveStarRatingSummary;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.NodeRef;

public class FiveStarRatingScheme
extends AbstractRatingScheme {
    public FiveStarRatingScheme() {
        super("fiveStar", "fiveStarRatingScheme");
    }

    public Float getRatingServiceRating(Object rating) {
        Float ratingToApply = null;
        if (!(rating instanceof Integer)) {
            throw new InvalidArgumentException("Rating should be non-null and an integer for 'fiveStar' rating scheme.");
        }
        ratingToApply = Float.valueOf(((Integer)rating).floatValue());
        this.validateRating(ratingToApply);
        return ratingToApply;
    }

    @Override
    public Object getApiRating(Float rating) {
        Integer apiRating = rating.intValue();
        return apiRating;
    }

    @Override
    public DocumentRatingSummary getDocumentRatingSummary(NodeRef nodeRef) {
        return new FiveStarRatingSummary(this.ratingService.getRatingsCount(nodeRef, this.ratingSchemeName), Float.valueOf(this.ratingService.getTotalRating(nodeRef, this.ratingSchemeName)), Float.valueOf(this.ratingService.getAverageRating(nodeRef, this.ratingSchemeName)));
    }

    @Override
    public void applyRating(NodeRef nodeRef, Object rating) {
        try {
            Float ratingServiceRating = this.getRatingServiceRating(rating);
            this.ratingService.applyRating(nodeRef, ratingServiceRating.floatValue(), this.getRatingServiceName());
        }
        catch (RatingServiceException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void removeRating(NodeRef nodeRef) {
        try {
            this.ratingService.removeRatingByCurrentUser(nodeRef, this.getRatingServiceName());
        }
        catch (RatingServiceException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }
}

