/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.alfresco.rest.api.impl.SiteSurfConfig;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterException;

public class SiteImportPackageHandler
implements ImportPackageHandler {
    private static final String SITEID_PLACEHOLDER = "${siteId}";
    private SiteSurfConfig config;
    private String siteId;

    public SiteImportPackageHandler(SiteSurfConfig config, String siteId) {
        this.config = config;
        this.siteId = siteId;
    }

    public void startImport() {
    }

    public Reader getDataStream() {
        return new StringReader(this.config.getImportView());
    }

    public InputStream importStream(String contentPath) {
        String content = this.config.getImportContent(contentPath);
        if (content == null) {
            return null;
        }
        String siteContent = content.replace(SITEID_PLACEHOLDER, this.siteId);
        try {
            return new ByteArrayInputStream(siteContent.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ImporterException("Failed to read content " + contentPath, (Throwable)e);
        }
    }

    public void endImport() {
    }
}

