/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.ClassDefinitionMapper;
import org.alfresco.rest.api.model.ConstraintDefinition;
import org.alfresco.rest.api.model.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;

public class ClassDefinitionMapperImpl
implements ClassDefinitionMapper {
    private final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0");
    private static final List<QName> EXCLUDED_PROPS = Arrays.asList(ContentModel.PROP_CONTENT);

    @Override
    public org.alfresco.rest.api.model.ClassDefinition fromDictionaryClassDefinition(ClassDefinition classDefinition, MessageLookup messageLookup) {
        if (classDefinition == null) {
            throw new AlfrescoRuntimeException("Undefined ClassDefinition for the node");
        }
        org.alfresco.rest.api.model.ClassDefinition _classDefinition = new org.alfresco.rest.api.model.ClassDefinition();
        _classDefinition.setProperties(this.getProperties(classDefinition.getProperties(), messageLookup));
        return _classDefinition;
    }

    private boolean isPropertyExcluded(QName propertyName) {
        return this.EXCLUDED_NS.contains(propertyName.getNamespaceURI()) || EXCLUDED_PROPS.contains(propertyName);
    }

    private List<PropertyDefinition> getProperties(Map<QName, org.alfresco.service.cmr.dictionary.PropertyDefinition> propertiesMap, MessageLookup messageLookup) {
        return propertiesMap.values().stream().filter(p -> !this.isPropertyExcluded(p.getName())).map(p -> this.fromPropertyDefinitionToProperty((org.alfresco.service.cmr.dictionary.PropertyDefinition)p, messageLookup)).collect(Collectors.toList());
    }

    private PropertyDefinition fromPropertyDefinitionToProperty(org.alfresco.service.cmr.dictionary.PropertyDefinition propertyDefinition, MessageLookup messageLookup) {
        PropertyDefinition property = new PropertyDefinition();
        property.setId(propertyDefinition.getName().toPrefixString());
        property.setTitle(propertyDefinition.getTitle(messageLookup));
        property.setDescription(propertyDefinition.getDescription(messageLookup));
        property.setDefaultValue(propertyDefinition.getDefaultValue());
        property.setDataType(propertyDefinition.getDataType().getName().toPrefixString());
        property.setIsMultiValued(propertyDefinition.isMultiValued());
        property.setIsMandatory(propertyDefinition.isMandatory());
        property.setIsMandatoryEnforced(propertyDefinition.isMandatoryEnforced());
        property.setIsProtected(propertyDefinition.isProtected());
        property.setConstraints(this.getConstraints(propertyDefinition.getConstraints(), messageLookup));
        return property;
    }

    private List<ConstraintDefinition> getConstraints(Collection<org.alfresco.service.cmr.dictionary.ConstraintDefinition> constraintDefinitions, MessageLookup messageLookup) {
        return constraintDefinitions.stream().filter(constraint -> constraint.getConstraint() != null).map(constraint -> this.fromConstraintDefinitionToConstraint((org.alfresco.service.cmr.dictionary.ConstraintDefinition)constraint, messageLookup)).collect(Collectors.toList());
    }

    private ConstraintDefinition fromConstraintDefinitionToConstraint(org.alfresco.service.cmr.dictionary.ConstraintDefinition constraintDefinition, MessageLookup messageLookup) {
        ConstraintDefinition constraint = new ConstraintDefinition();
        constraint.setId(constraintDefinition.getConstraint().getShortName());
        constraint.setType(constraintDefinition.getConstraint().getType());
        constraint.setTitle(constraintDefinition.getTitle(messageLookup));
        constraint.setDescription(constraintDefinition.getDescription(messageLookup));
        constraint.setParameters(constraintDefinition.getConstraint().getParameters());
        return constraint;
    }
}

