/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import jakarta.servlet.http.HttpServletRequest;
import org.alfresco.repo.web.scripts.TenantWebScriptServletRequest;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;

public class PublicApiTenantWebScriptServletRequest
extends TenantWebScriptServletRequest {
    public static final String NETWORKS_PATH = "networks";
    public static final String NETWORK_PATH = "network";

    public PublicApiTenantWebScriptServletRequest(Runtime container, HttpServletRequest req, Match serviceMatch, ServerProperties serverProperties) {
        super(container, req, serviceMatch, serverProperties);
    }

    @Override
    protected void parse() {
        String realPathInfo = this.getRealPathInfo();
        if (realPathInfo.equals("") || realPathInfo.equals("/")) {
            this.tenant = "-default-";
            this.pathInfo = NETWORKS_PATH;
        } else if (realPathInfo.equals("/discovery")) {
            this.tenant = "-default-";
            this.pathInfo = realPathInfo;
        } else if (realPathInfo.substring(0, 5).toLowerCase().equals("/cmis")) {
            this.tenant = "-default-";
            this.pathInfo = realPathInfo;
        } else {
            int idx = realPathInfo.indexOf(47, 1);
            this.tenant = realPathInfo.substring(1, idx == -1 ? realPathInfo.length() : idx);
            this.pathInfo = realPathInfo.substring(this.tenant.length() + 1);
        }
    }
}

