/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.io.IOException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.web.scripts.TenantRepositoryContainer;
import org.alfresco.rest.api.PublicApiTenantWebScriptServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class PublicApiRepositoryContainer
extends TenantRepositoryContainer {
    protected static final Log logger = LogFactory.getLog(PublicApiRepositoryContainer.class);

    @Override
    public void executeScript(final WebScriptRequest scriptReq, final WebScriptResponse scriptRes, final Authenticator auth) throws IOException {
        String tenant = ((PublicApiTenantWebScriptServletRequest)scriptReq).getTenant();
        if (tenant != null) {
            String user = null;
            if (tenant.equalsIgnoreCase("-default-") && (user = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
                tenant = "-system-";
            }
            if (tenant.equalsIgnoreCase("-system-")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("executeScript (-system-): [" + user + "," + tenant + "] " + scriptReq.getServicePath()));
                }
                TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        PublicApiRepositoryContainer.super.executeScript(scriptReq, scriptRes, auth);
                        return null;
                    }
                }, (String)"");
            } else {
                if (tenant.equalsIgnoreCase("-default-")) {
                    tenant = this.tenantAdminService.getUserDomain(user);
                }
                TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        PublicApiRepositoryContainer.super.executeScript(scriptReq, scriptRes, auth);
                        return null;
                    }
                }, (String)tenant);
            }
        }
    }
}

