/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowInstanceQuery;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.util.StringUtils;

public class WorkflowInstancesGet
extends AbstractWorkflowWebscript {
    public static final String PARAM_STATE = "state";
    public static final String PARAM_INITIATOR = "initiator";
    public static final String PARAM_PRIORITY = "priority";
    public static final String PARAM_DUE_BEFORE = "dueBefore";
    public static final String PARAM_DUE_AFTER = "dueAfter";
    public static final String PARAM_STARTED_BEFORE = "startedBefore";
    public static final String PARAM_STARTED_AFTER = "startedAfter";
    public static final String PARAM_COMPLETED_BEFORE = "completedBefore";
    public static final String PARAM_COMPLETED_AFTER = "completedAfter";
    public static final String PARAM_DEFINITION_NAME = "definitionName";
    public static final String PARAM_DEFINITION_ID = "definitionId";
    public static final String VAR_DEFINITION_ID = "workflow_definition_id";
    public static final QName QNAME_INITIATOR = QName.createQName((String)"", (String)"initiator");
    private WorkflowInstanceDueAscComparator workflowComparator = new WorkflowInstanceDueAscComparator();

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Date dueAfter;
        String excludeParam;
        WorkflowInstanceQuery workflowInstanceQuery = new WorkflowInstanceQuery();
        Map params = req.getServiceMatch().getTemplateVars();
        WorkflowState state = this.getState(req);
        HashMap<QName, Object> filters = new HashMap<QName, Object>(9);
        if (req.getParameter(PARAM_INITIATOR) != null) {
            filters.put(QNAME_INITIATOR, this.personService.getPerson(req.getParameter(PARAM_INITIATOR)));
        }
        if (req.getParameter(PARAM_PRIORITY) != null) {
            filters.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, req.getParameter(PARAM_PRIORITY));
        }
        if ((excludeParam = req.getParameter("exclude")) != null && excludeParam.length() > 0) {
            workflowInstanceQuery.setExcludedDefinitions(Arrays.asList(StringUtils.tokenizeToStringArray((String)excludeParam, (String)",")));
        }
        HashMap<WorkflowInstanceQuery.DatePosition, Date> dateParams = new HashMap<WorkflowInstanceQuery.DatePosition, Date>();
        Date dueBefore = this.getDateFromRequest(req, PARAM_DUE_BEFORE);
        if (dueBefore != null) {
            dateParams.put(WorkflowInstanceQuery.DatePosition.BEFORE, dueBefore);
        }
        if ((dueAfter = this.getDateFromRequest(req, PARAM_DUE_AFTER)) != null) {
            dateParams.put(WorkflowInstanceQuery.DatePosition.AFTER, dueAfter);
        }
        if (dateParams.isEmpty()) {
            if (req.getParameter(PARAM_DUE_BEFORE) != null || req.getParameter(PARAM_DUE_AFTER) != null) {
                filters.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, null);
            }
        } else {
            filters.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dateParams);
        }
        workflowInstanceQuery.setStartBefore(this.getDateFromRequest(req, PARAM_STARTED_BEFORE));
        workflowInstanceQuery.setStartAfter(this.getDateFromRequest(req, PARAM_STARTED_AFTER));
        workflowInstanceQuery.setEndBefore(this.getDateFromRequest(req, PARAM_COMPLETED_BEFORE));
        workflowInstanceQuery.setEndAfter(this.getDateFromRequest(req, PARAM_COMPLETED_AFTER));
        String workflowDefinitionId = (String)params.get(VAR_DEFINITION_ID);
        if (workflowDefinitionId == null) {
            workflowDefinitionId = req.getParameter(PARAM_DEFINITION_ID);
        }
        if (state == null) {
            state = WorkflowState.ACTIVE;
        }
        workflowInstanceQuery.setActive(Boolean.valueOf(state == WorkflowState.ACTIVE));
        workflowInstanceQuery.setCustomProps(filters);
        ArrayList workflows = new ArrayList();
        int total = 0;
        int maxItems = this.getIntParameter(req, "maxItems", -1);
        int skipCount = this.getIntParameter(req, "skipCount", 0);
        if (workflowDefinitionId == null && req.getParameter(PARAM_DEFINITION_NAME) != null) {
            int workingSkipCount = skipCount;
            String definitionName = req.getParameter(PARAM_DEFINITION_NAME);
            List defs = this.workflowService.getAllDefinitionsByName(definitionName);
            int itemsToQuery = maxItems;
            for (WorkflowDefinition def : defs) {
                workflowDefinitionId = def.getId();
                workflowInstanceQuery.setWorkflowDefinitionId(workflowDefinitionId);
                if (maxItems < 0 || itemsToQuery > 0) {
                    workflows.addAll(this.workflowService.getWorkflows(workflowInstanceQuery, itemsToQuery, workingSkipCount));
                }
                if (maxItems > 0) {
                    itemsToQuery = maxItems - workflows.size();
                }
                if (workingSkipCount <= 0 || (workingSkipCount = skipCount - (total += (int)this.workflowService.countWorkflows(workflowInstanceQuery))) >= 0) continue;
                workingSkipCount = 0;
            }
        } else {
            if (workflowDefinitionId != null) {
                workflowInstanceQuery.setWorkflowDefinitionId(workflowDefinitionId);
            }
            workflows.addAll(this.workflowService.getWorkflows(workflowInstanceQuery, maxItems, skipCount));
            total = (int)this.workflowService.countWorkflows(workflowInstanceQuery);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(total);
        results.addAll(Arrays.asList(new Map[total]));
        for (WorkflowInstance workflow : workflows) {
            results.set(skipCount, modelBuilder.buildSimple(workflow));
            ++skipCount;
        }
        return this.createResultModel(req, "workflowInstances", results);
    }

    private WorkflowState getState(WebScriptRequest req) {
        String stateName = req.getParameter(PARAM_STATE);
        if (stateName != null) {
            try {
                return WorkflowState.valueOf(stateName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                String msg = "Unrecognised State parameter: " + stateName;
                throw new WebScriptException(400, msg);
            }
        }
        return null;
    }

    private Date getDateFromRequest(WebScriptRequest req, String paramName) {
        String dateParam = req.getParameter(paramName);
        if (dateParam != null && !"".equals(dateParam) && !"null".equals(dateParam)) {
            return this.getDateParameter(req, paramName);
        }
        return null;
    }

    class WorkflowInstanceDueAscComparator
    implements Comparator<WorkflowInstance> {
        WorkflowInstanceDueAscComparator() {
        }

        @Override
        public int compare(WorkflowInstance o1, WorkflowInstance o2) {
            Date date2;
            long time2;
            Date date1 = o1.getDueDate();
            long time1 = date1 == null ? Long.MAX_VALUE : date1.getTime();
            long result = time1 - (time2 = (date2 = o2.getDueDate()) == null ? Long.MAX_VALUE : date2.getTime());
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }
    }

    private static enum WorkflowState {
        ACTIVE,
        COMPLETED;

    }
}

