/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.rating.AbstractRatingWebScript;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RatingsGet
extends AbstractRatingWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        ArrayList<Rating> myRatings = new ArrayList<Rating>();
        HashMap<String, Float> averageRatings = new HashMap<String, Float>();
        HashMap<String, Float> ratingsTotals = new HashMap<String, Float>();
        HashMap<String, Integer> ratingsCounts = new HashMap<String, Integer>();
        for (String schemeName : this.ratingService.getRatingSchemes().keySet()) {
            Rating ratingByCurrentUser = this.ratingService.getRatingByCurrentUser(nodeRef, schemeName);
            if (ratingByCurrentUser != null) {
                myRatings.add(ratingByCurrentUser);
            }
            averageRatings.put(schemeName, Float.valueOf(this.ratingService.getAverageRating(nodeRef, schemeName)));
            ratingsTotals.put(schemeName, Float.valueOf(this.ratingService.getTotalRating(nodeRef, schemeName)));
            ratingsCounts.put(schemeName, this.ratingService.getRatingsCount(nodeRef, schemeName));
        }
        model.put("nodeRef", nodeRef.toString());
        model.put("ratings", myRatings);
        model.put("averageRatings", averageRatings);
        model.put("ratingsTotals", ratingsTotals);
        model.put("ratingsCounts", ratingsCounts);
        return model;
    }
}

