/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.nodelocator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.nodelocator.NodeLocatorService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodeLocatorGet
extends DeclarativeWebScript {
    private static final String NODE_ID = "node_id";
    private static final String STORE_ID = "store_id";
    private static final String STORE_TYPE = "store_type";
    private static final String NODE_LOCATOR_NAME = "node_locator_name";
    private NodeLocatorService locatorService;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        Map vars = req.getServiceMatch().getTemplateVars();
        String locatorName = (String)vars.get(NODE_LOCATOR_NAME);
        if (locatorName == null) {
            throw new WebScriptException(404, "No NodeLocator strategy was specified!");
        }
        NodeRef source = null;
        String storeType = (String)vars.get(STORE_TYPE);
        String storeId = (String)vars.get(STORE_ID);
        String nodeId = (String)vars.get(NODE_ID);
        if (storeType != null && storeId != null && nodeId != null) {
            source = new NodeRef(storeType, storeId, nodeId);
        }
        Map<String, Serializable> params = this.mapParams(req);
        NodeRef node = this.locatorService.getNode(locatorName, source, params);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("nodeRef", node == null ? null : node.toString());
        return model;
    }

    private Map<String, Serializable> mapParams(WebScriptRequest req) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (String key : req.getParameterNames()) {
            String value = req.getParameter(key);
            if (value == null) continue;
            String decodedValue = URLDecoder.decode((String)value);
            params.put(key, (Serializable)((Object)decodedValue));
        }
        return params;
    }

    public void setNodeLocatorService(NodeLocatorService locatorService) {
        this.locatorService = locatorService;
    }
}

