/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.links.AbstractLinksWebScript;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LinksPost
extends AbstractLinksWebScript {
    private static final String MSG_ACCESS_DENIED = "links.err.access.denied";

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String linkName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        LinkInfo link;
        ResourceBundle rb = this.getResources();
        HashMap<String, Object> model = new HashMap<String, Object>();
        String title = this.getOrNull(json, "title");
        String description = this.getOrNull(json, "description");
        String url = this.getOrNull(json, "url");
        boolean internal = json.containsKey((Object)"internal");
        List<String> tags = this.getTags(json);
        try {
            link = this.linksService.createLink(site.getShortName(), title, description, url, internal);
        }
        catch (AccessDeniedException e) {
            String message = "You don't have permission to create a link";
            status.setCode(403);
            status.setMessage(message);
            model.put("message", rb.getString(MSG_ACCESS_DENIED));
            return model;
        }
        if (tags != null && tags.size() > 0) {
            link.getTags().addAll(tags);
            this.linksService.updateLink(link);
        }
        this.addActivityEntry("created", link, site, req, json);
        model.put("message", link.getSystemName());
        model.put("item", this.renderLink(link));
        model.put("node", link.getNodeRef());
        model.put("link", link);
        model.put("site", site);
        model.put("siteId", site.getShortName());
        return model;
    }
}

