/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractSolrFacetConfigAdminWebScript
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(AbstractSolrFacetConfigAdminWebScript.class);
    protected static final String PARAM_FILTER_ID = "filterID";
    protected static final String PARAM_FACET_QNAME = "facetQName";
    protected static final String PARAM_DISPLAY_NAME = "displayName";
    protected static final String PARAM_DISPLAY_CONTROL = "displayControl";
    protected static final String PARAM_MAX_FILTERS = "maxFilters";
    protected static final String PARAM_HIT_THRESHOLD = "hitThreshold";
    protected static final String PARAM_MIN_FILTER_VALUE_LENGTH = "minFilterValueLength";
    protected static final String PARAM_SORT_BY = "sortBy";
    protected static final String PARAM_SCOPE = "scope";
    protected static final String PARAM_SCOPED_SITES = "scopedSites";
    protected static final String PARAM_INDEX = "index";
    protected static final String PARAM_IS_ENABLED = "isEnabled";
    protected static final String PARAM_CUSTOM_PROPERTIES = "customProperties";
    protected static final String CUSTOM_PARAM_NAME = "name";
    protected static final String CUSTOM_PARAM_VALUE = "value";
    protected static final Pattern FILTER_ID_PATTERN = Pattern.compile("([\"\\*\\\\\\>\\<\\?\\/\\:\\|]+)|([\\.]?[\\.]+$)");
    protected SolrFacetService facetService;
    protected NamespaceService namespaceService;

    public void setFacetService(SolrFacetService facetService) {
        this.facetService = facetService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        this.validateCurrentUser();
        return this.unprotectedExecuteImpl(req, status, cache);
    }

    protected void validateCurrentUser() {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (!this.facetService.isSearchAdmin(currentUser)) {
            throw new WebScriptException(403, "Access denied.");
        }
    }

    protected <T> T getValue(Class<T> clazz, Object value, T defaultValue) throws JSONException {
        if (JSONObject.NULL.equals(value)) {
            return defaultValue;
        }
        try {
            return clazz.cast(value);
        }
        catch (Exception ex) {
            throw new JSONException("JSONObject[" + String.valueOf(value) + "] is not an instance of [" + clazz.getName() + "]");
        }
    }

    protected Set<SolrFacetProperties.CustomProperties> getCustomProperties(JSONObject customPropsJsonObj) throws JSONException {
        if (customPropsJsonObj == null) {
            return null;
        }
        JSONArray keys = customPropsJsonObj.names();
        if (keys == null) {
            return Collections.emptySet();
        }
        HashSet<SolrFacetProperties.CustomProperties> customProps = new HashSet<SolrFacetProperties.CustomProperties>(keys.length());
        int length = keys.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObj = customPropsJsonObj.getJSONObject((String)keys.get(i));
            QName name = this.resolveToQName(this.getValue(String.class, jsonObj.opt(CUSTOM_PARAM_NAME), null));
            this.validateMandatoryCustomProps(name, CUSTOM_PARAM_NAME);
            ArrayList<Serializable> value = null;
            Object customPropValue = jsonObj.opt(CUSTOM_PARAM_VALUE);
            this.validateMandatoryCustomProps(customPropValue, CUSTOM_PARAM_VALUE);
            if (customPropValue instanceof JSONArray) {
                JSONArray array = (JSONArray)customPropValue;
                ArrayList<Serializable> list = new ArrayList<Serializable>(array.length());
                for (int j = 0; j < array.length(); ++j) {
                    list.add(this.getSerializableValue(array.get(j)));
                }
                value = list;
            } else {
                value = this.getSerializableValue(customPropValue);
            }
            customProps.add(new SolrFacetProperties.CustomProperties(name, (Serializable)value));
        }
        if (logger.isDebugEnabled() && customProps.size() > 0) {
            logger.debug((Object)("Processed custom properties:" + String.valueOf(customProps)));
        }
        return customProps;
    }

    protected Set<String> getScopedSites(JSONArray scopedSitesJsonArray) throws JSONException {
        if (scopedSitesJsonArray == null) {
            return null;
        }
        HashSet<String> scopedSites = new HashSet<String>(scopedSitesJsonArray.length());
        int length = scopedSitesJsonArray.length();
        for (int i = 0; i < length; ++i) {
            String site = scopedSitesJsonArray.getString(i);
            scopedSites.add(site);
        }
        return scopedSites;
    }

    private void validateMandatoryCustomProps(Object obj, String paramName) throws JSONException {
        if (obj == null) {
            throw new JSONException("Invalid JSONObject in the Custom Properties JSON. [" + paramName + "] cannot be null.");
        }
    }

    protected void validateFilterID(String filterID) {
        Matcher matcher = FILTER_ID_PATTERN.matcher(filterID);
        if (matcher.find()) {
            throw new WebScriptException(400, "Invalid Filter Id. The characters \" * \\ < > ? / : | are not allowed. The Filter Id cannot end with a dot.");
        }
    }

    private Serializable getSerializableValue(Object object) throws JSONException {
        if (!(object instanceof Serializable)) {
            throw new JSONException("Invalid value in the Custom Properties JSON. [" + String.valueOf(object) + "] must be an instance of Serializable.");
        }
        return (Serializable)object;
    }

    private QName resolveToQName(String qnameStr) throws JSONException {
        QName typeQName = null;
        if (qnameStr == null) {
            return typeQName;
        }
        if (qnameStr.charAt(0) == '{' && qnameStr.indexOf("solrfacetcustomproperty") < 0) {
            throw new JSONException("Invalid name in the Custom Properties JSON. Namespace URL must be [http://www.alfresco.org/model/solrfacetcustomproperty/1.0]");
        }
        typeQName = qnameStr.charAt(0) == '{' ? QName.createQName((String)qnameStr) : QName.createQName((String)"http://www.alfresco.org/model/solrfacetcustomproperty/1.0", (String)qnameStr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved facet's custom property name [" + qnameStr + "] into [" + String.valueOf(typeQName) + "]"));
        }
        return typeQName;
    }

    protected int getNonNegativeIntParameter(WebScriptRequest req, String paramName, int defaultValue) {
        int result;
        String paramString = req.getParameter(paramName);
        if (paramString != null) {
            try {
                int paramInt = Integer.valueOf(paramString);
                if (paramInt < 0) {
                    result = defaultValue;
                }
                result = paramInt;
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, e.getMessage());
            }
        } else {
            result = defaultValue;
        }
        return result;
    }

    protected abstract Map<String, Object> unprotectedExecuteImpl(WebScriptRequest var1, Status var2, Cache var3);
}

