/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary.prefixed;

import java.util.Collection;
import org.alfresco.repo.web.scripts.dictionary.AbstractSubClassesGet;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SubClassesGet
extends AbstractSubClassesGet {
    private static final String DICTIONARY_PREFIX = "prefix";
    private static final String DICTIONARY_CLASS_SHORTNAME = "shortClassName";

    @Override
    protected Collection<QName> getQNameCollection(WebScriptRequest req, boolean recursive) {
        String prefix = (String)req.getServiceMatch().getTemplateVars().get(DICTIONARY_PREFIX);
        String shortClassName = (String)req.getServiceMatch().getTemplateVars().get(DICTIONARY_CLASS_SHORTNAME);
        QName classQName = null;
        boolean isAspect = false;
        if (this.isValidClassname(prefix, shortClassName)) {
            classQName = QName.createQName((String)this.getFullNamespaceURI(prefix, shortClassName));
            if (this.isValidTypeorAspect(prefix, shortClassName)) {
                isAspect = true;
            }
        } else {
            throw new WebScriptException(404, "Check the className - " + prefix + ":" + shortClassName + " parameter in the URL");
        }
        if (isAspect) {
            return this.dictionaryservice.getSubAspects(classQName, recursive);
        }
        return this.dictionaryservice.getSubTypes(classQName, recursive);
    }

    @Override
    protected void validateClassname(String namespacePrefix, String name) {
        if (!this.isValidClassname(namespacePrefix, name)) {
            throw new WebScriptException(404, "Check the namespacePrefix - " + namespacePrefix + " and name - " + name + " - parameter in the URL");
        }
    }
}

