/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class OpenSearchConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "opensearch";
    private ProxyConfig proxy;
    private Set<EngineConfig> engines = new HashSet<EngineConfig>(8, 10.0f);
    private Map<String, EngineConfig> enginesByProxy = new HashMap<String, EngineConfig>();

    public OpenSearchConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public OpenSearchConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the open search config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        OpenSearchConfigElement newElement = (OpenSearchConfigElement)configElement;
        OpenSearchConfigElement combinedElement = new OpenSearchConfigElement();
        for (EngineConfig plugin : this.getEngines()) {
            combinedElement.addEngine(plugin);
        }
        for (EngineConfig plugin : newElement.getEngines()) {
            combinedElement.addEngine(plugin);
        }
        ProxyConfig proxyConfig = this.getProxy();
        if (proxyConfig != null) {
            combinedElement.setProxy(proxyConfig);
        }
        return combinedElement;
    }

    void setProxy(ProxyConfig proxyConfig) {
        this.proxy = proxyConfig;
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public Set<EngineConfig> getEngines() {
        return this.engines;
    }

    public EngineConfig getEngine(String proxy) {
        return this.enginesByProxy.get(proxy);
    }

    void addEngine(EngineConfig engineConfig) {
        this.engines.add(engineConfig);
        String proxy = engineConfig.getProxy();
        if (proxy != null && proxy.length() > 0) {
            this.enginesByProxy.put(proxy, engineConfig);
        }
    }

    public static class EngineConfig {
        protected String label;
        protected String labelId;
        protected String proxy;
        protected Map<String, String> urls = new HashMap<String, String>(8, 10.0f);

        public EngineConfig(String label, String labelId) {
            if (!(label != null && label.length() != 0 || labelId != null && labelId.length() != 0)) {
                throw new IllegalArgumentException("'label' or 'label-id' must be specified");
            }
            this.label = label;
            this.labelId = labelId;
        }

        public EngineConfig(String label, String labelId, String proxy) {
            this(label, labelId);
            this.proxy = proxy;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getProxy() {
            return this.proxy;
        }

        public Map<String, String> getUrls() {
            return this.urls;
        }

        void addUrl(String mimetype, String uri) {
            this.urls.put(mimetype, uri);
        }
    }

    public static class ProxyConfig {
        protected String url;

        public ProxyConfig(String url) {
            if (url == null || url.length() == 0) {
                throw new IllegalArgumentException("'url' must be specified");
            }
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

